/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.feed.atom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.feed.FeedFactory;
import org.wso2.wsas.feed.atom.AtomFeed;
import org.wso2.wsas.feed.rss.ServiceElement;

public class AtomFeedBuilder {
    private static Log log = LogFactory.getLog((Class)AtomFeedBuilder.class);
    private AtomFeed atomFeed = FeedFactory.getAtomFeed("wso2wsas.atom");

    public void addService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            ArrayList<String> operations = new ArrayList<String>();
            Iterator ops = serviceDescription.getOperations();
            while (ops.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)ops.next();
                operations.add(axisOperation.getName().getLocalPart());
            }
            serviceElement.setOperations(operations);
            ArrayList<String> modules = new ArrayList<String>();
            Iterator mdits = serviceDescription.getEngagedModules().iterator();
            while (mdits.hasNext()) {
                AxisModule axisModule = (AxisModule)mdits.next();
                modules.add(axisModule.getName());
            }
            serviceElement.setModules(modules);
            serviceElement.setEventType(0);
            this.atomFeed.addAtomElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending add service " + serviceDescription.getName() + " event to the Atom feed"), (Throwable)e);
        }
    }

    public void removeService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setUpdate(true);
            serviceElement.setEventType(1);
            this.atomFeed.addAtomElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the remove service " + serviceDescription.getName() + " event to the Atom feed"), (Throwable)e);
        }
    }

    public void stopService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setUpdate(true);
            serviceElement.setEventType(3);
            this.atomFeed.addAtomElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the stop service " + serviceDescription.getName() + " event to the Atom feed"), (Throwable)e);
        }
    }

    public void startService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setUpdate(true);
            serviceElement.setEventType(4);
            this.atomFeed.addAtomElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the start service " + serviceDescription.getName() + " event to the Atom feed"), (Throwable)e);
        }
    }

    public void serviceUpdate(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setUpdate(true);
            ArrayList<String> operations = new ArrayList<String>();
            Iterator ops = serviceDescription.getOperations();
            while (ops.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)ops.next();
                operations.add(axisOperation.getName().getLocalPart());
            }
            serviceElement.setOperations(operations);
            ArrayList<String> modules = new ArrayList<String>();
            Iterator mdits = serviceDescription.getEngagedModules().iterator();
            while (mdits.hasNext()) {
                AxisModule axisModule = (AxisModule)mdits.next();
                modules.add(axisModule.getName());
            }
            serviceElement.setModules(modules);
            serviceElement.setEventType(2);
            this.atomFeed.addAtomElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the update service " + serviceDescription.getName() + " event to the Atom feed"), (Throwable)e);
        }
    }
}

