/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.feed.atom;

import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerManager;

public class AtomElement {
    private static Log log = LogFactory.getLog((Class)AtomElement.class);
    private OMElement atomElement;

    public AtomElement(OMFactory fac) {
        this.atomElement = fac.createOMElement("feed", null);
        this.atomElement.addAttribute("xmlns", "http://www.w3.org/2005/Atom", null);
        OMElement titileElement = fac.createOMElement("title", null);
        titileElement.setText("WSO2 WSAS Atom");
        this.atomElement.addChild((OMNode)titileElement);
        OMElement link = fac.createOMElement("link", null);
        String ip = null;
        try {
            ip = NetworkUtils.getLocalHostname();
            ip = "http://" + ip + ":" + ServerManager.getInstance().getHttpPort();
        }
        catch (SocketException e) {
            log.warn((Object)"NetworkUtils.getLocalHostname()");
        }
        OMElement modified = fac.createOMElement("updated", null);
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Date currentTime = Calendar.getInstance().getTime();
        modified.setText(zulu.format(currentTime));
        this.atomElement.addChild((OMNode)modified);
        link.addAttribute("rel", "alternate", null);
        link.addAttribute("type", "text/html", null);
        link.addAttribute("href", ip, null);
        this.atomElement.addChild((OMNode)link);
        OMElement author = fac.createOMElement("author", null);
        OMElement name = fac.createOMElement("name", null);
        OMElement uri = fac.createOMElement("uri", null);
        uri.setText("http://www.wso2.org");
        OMElement emal = fac.createOMElement("email", null);
        emal.setText("info@wso2.org");
        name.setText("WSO2 WSAS");
        author.addChild((OMNode)name);
        author.addChild((OMNode)uri);
        author.addChild((OMNode)emal);
        OMElement id = fac.createOMElement("id", null);
        id.setText(UUIDGenerator.getUUID());
        this.atomElement.addChild((OMNode)id);
        this.atomElement.addChild((OMNode)author);
    }

    public OMElement getElement() {
        return this.atomElement;
    }
}

