/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.feed;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.wso2.wsas.feed.atom.AtomFeedBuilder;
import org.wso2.wsas.feed.rss.RSSFeedBuilder;
import org.wso2.wsas.util.SystemFilter;

public class FeedListener
implements AxisObserver {
    public static int MAX_ARRAY_SIZE = 10;
    private ParameterInclude parameterInclude = new ParameterIncludeImpl();
    private RSSFeedBuilder rssFeedBuilder;
    private AtomFeedBuilder atomFeedBuilder;
    private ArrayList services;

    public void init(AxisConfiguration axisConfig) {
        this.rssFeedBuilder = new RSSFeedBuilder();
        this.atomFeedBuilder = new AtomFeedBuilder();
        this.services = new ArrayList();
    }

    public void serviceUpdate(AxisEvent event, AxisService service) {
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)service.getParent();
        String itemHome = "http://127.0.0.1:8080/axis2/";
        if (this.getParameter("FEED_ITEM_DEFAULT_URL") != null) {
            itemHome = this.getParameter("FEED_ITEM_DEFAULT_URL").getValue().toString();
        }
        if (SystemFilter.isFilteredOutService(axisServiceGroup.getServiceGroupName())) {
            return;
        }
        if (this.services.contains(service)) {
            this.rssFeedBuilder.serviceUpdate(service, itemHome);
            this.atomFeedBuilder.serviceUpdate(service, itemHome);
        } else if (1 == event.getEventType()) {
            this.rssFeedBuilder.addService(service, itemHome);
            this.atomFeedBuilder.addService(service, itemHome);
        } else if (0 == event.getEventType()) {
            this.rssFeedBuilder.removeService(service, itemHome);
            this.atomFeedBuilder.removeService(service, itemHome);
        } else if (3 == event.getEventType()) {
            this.rssFeedBuilder.startService(service, itemHome);
            this.atomFeedBuilder.startService(service, itemHome);
        } else if (2 == event.getEventType()) {
            this.rssFeedBuilder.stopService(service, itemHome);
            this.atomFeedBuilder.stopService(service, itemHome);
        }
    }

    public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
    }

    public void moduleUpdate(AxisEvent event, AxisModule module) {
    }

    public void addParameter(Parameter param) throws AxisFault {
        if ("maxSize".equals(param.getName())) {
            String value = (String)param.getValue();
            MAX_ARRAY_SIZE = Integer.parseInt(value.trim());
        }
        this.parameterInclude.addParameter(param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameterInclude.removeParameter(param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public Parameter getParameter(String name) {
        return this.parameterInclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.parameterInclude.getParameters();
    }

    public boolean isParameterLocked(String parameterName) {
        return this.parameterInclude.isParameterLocked(parameterName);
    }
}

