/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupDO;
import org.wso2.wsas.persistence.exception.EJBConfigurationNotFoundException;
import org.wso2.wsas.persistence.exception.ServiceGroupNotFoundException;
import org.wso2.wsas.persistence.exception.ServiceNotFoundException;
import org.wso2.wsas.security.ServerCrypto;
import org.wso2.wsas.security.util.RampartConfigUtil;
import org.wso2.wsas.util.SystemFilter;
import org.wso2.wsas.util.WsasUtils;

public class DeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog((Class)DeploymentInterceptor.class);
    private final Map paramMap = new HashMap();
    private PersistenceManager persistenceMgr;
    private AxisConfiguration axisConfig;

    public void init(AxisConfiguration axisConfig) {
        this.persistenceMgr = new PersistenceManager();
        this.axisConfig = axisConfig;
    }

    public void serviceGroupUpdate(AxisEvent axisEvent, AxisServiceGroup axisServiceGroup) {
        if (SystemFilter.isFilteredOutService(axisServiceGroup.getServiceGroupName())) {
            return;
        }
        int eventType = axisEvent.getEventType();
        if (eventType == 1) {
            ServiceGroupDO sgDO = this.persistenceMgr.getServiceGroup(axisServiceGroup.getServiceGroupName());
            if (sgDO == null) {
                this.addServiceGroup(axisServiceGroup);
            } else if (!sgDO.getServiceArtifactUpdateTime().equals(WsasUtils.lastUpdatedTime(axisServiceGroup))) {
                log.warn((Object)("The service artifact of the " + axisServiceGroup.getServiceGroupName() + " service group has changed. Removing all database entries and " + "handling this as a new service addition."));
                this.deleteServiceGroup(axisServiceGroup);
                this.addServiceGroup(axisServiceGroup);
            } else {
                try {
                    this.persistenceMgr.handleExistingServiceGroupInit(sgDO, axisServiceGroup);
                }
                catch (Exception e) {
                    String msg = "Could not handle initialization of existing service group [" + axisServiceGroup.getServiceGroupName() + "]";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        } else if (eventType == 0) {
            this.deleteServiceGroup(axisServiceGroup);
        }
    }

    private void addServiceGroup(AxisServiceGroup axisServiceGroup) {
        try {
            this.persistenceMgr.handleNewServiceGroupAddition(axisServiceGroup);
        }
        catch (Exception e) {
            String msg = "Could not handle initialization of new service group [" + axisServiceGroup.getServiceGroupName() + "]";
            log.error((Object)msg, (Throwable)e);
        }
    }

    private void deleteServiceGroup(AxisServiceGroup axisServiceGroup) {
        try {
            this.persistenceMgr.deleteServiceGroup(axisServiceGroup);
        }
        catch (ServiceGroupNotFoundException e) {
            log.error((Object)"Service group not found", (Throwable)e);
        }
    }

    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        if (SystemFilter.isFilteredOutService(((AxisServiceGroup)axisService.getParent()).getServiceGroupName())) {
            return;
        }
        if (axisService.isClientSide()) {
            return;
        }
        int eventType = axisEvent.getEventType();
        String serviceName = axisService.getName();
        String serviceVersion = "$EMPTY$";
        ServiceDO serviceDO = this.persistenceMgr.getService(serviceName, serviceVersion);
        if (eventType == 3) {
            ServiceDO service = this.persistenceMgr.getService(serviceName, "$EMPTY$");
            service.setIsActive(true);
            this.persistenceMgr.updateEntity(service);
        } else if (eventType == 2) {
            ServiceDO service = this.persistenceMgr.getService(serviceName, "$EMPTY$");
            service.setIsActive(false);
            this.persistenceMgr.updateEntity(service);
        } else if (eventType == 0) {
            if (serviceDO != null) {
                try {
                    this.persistenceMgr.deleteService(serviceName, serviceVersion);
                    this.removeEJBServiceConfiguration(axisService);
                }
                catch (ServiceNotFoundException ignored) {
                }
                catch (Exception e) {
                    String msg = "Cannot delete serviceDO [" + serviceName + "]";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        } else {
            String msg;
            if (axisService.getName().equals("wso2wsas-sts") && axisEvent.getEventType() == 1) {
                ServerConfiguration config = ServerConfiguration.getInstance();
                KeyStoreDO[] keystores = this.persistenceMgr.getKeyStores();
                KeyStoreDO sysKs = null;
                for (int i = 0; i < keystores.length; ++i) {
                    if (!keystores[i].getIsPrimaryKeyStore()) continue;
                    sysKs = keystores[i];
                    break;
                }
                if (sysKs != null) {
                    String issuerName = config.getFirstProperty("HostName");
                    if (issuerName == null) {
                        issuerName = "wso2wsas-sts";
                    }
                    String cryptoProvider = ServerCrypto.class.getName();
                    String ksId = sysKs.getKeyStoreName();
                    Properties props = RampartConfigUtil.getServerCryptoProperties(new String[]{ksId}, ksId, sysKs.getPrivateKeyAlias());
                    SAMLTokenIssuerConfig stsSamlConfig = new SAMLTokenIssuerConfig(issuerName, cryptoProvider, props);
                    stsSamlConfig.setIssuerKeyAlias(config.getFirstProperty("Security.KeyStore.KeyAlias"));
                    stsSamlConfig.setIssuerKeyPassword(config.getFirstProperty("Security.KeyStore.KeyPassword"));
                    stsSamlConfig.setAddRequestedAttachedRef(true);
                    stsSamlConfig.setAddRequestedUnattachedRef(true);
                    stsSamlConfig.setKeyComputation(2);
                    stsSamlConfig.setProofKeyType("BinarySecret");
                    try {
                        Parameter param = axisService.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
                        if (param == null) {
                            axisService.addParameter(stsSamlConfig.getParameter());
                        }
                    }
                    catch (AxisFault e) {
                        log.error((Object)"Error setting STS-SAML configuration parameter", (Throwable)e);
                    }
                }
            }
            if (serviceDO == null) {
                try {
                    this.persistenceMgr.handleNewServiceAddition(axisService);
                }
                catch (Exception e) {
                    msg = "Could not handle initialization of new service [" + axisService.getName() + "]";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.persistenceMgr.handleExistingServiceInit(serviceDO, axisService, this.axisConfig);
                }
                catch (Exception e) {
                    msg = "Could not handle initialization of existing service [" + axisService.getName() + "]";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private void removeEJBServiceConfiguration(AxisService axisService) {
        String serviceType = (String)axisService.getParameterValue("serviceType");
        if ("ejb_service".equals(serviceType)) {
            String beanJNDIName = (String)axisService.getParameter("beanJndiName").getValue();
            String jnpProviderUrl = (String)axisService.getParameter("providerUrl").getValue();
            try {
                this.persistenceMgr.removeEJBConfiguration(beanJNDIName, jnpProviderUrl);
            }
            catch (EJBConfigurationNotFoundException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public void moduleUpdate(AxisEvent axisEvent, AxisModule axisModule) {
        ModuleDO moduleDO;
        String moduleName = axisModule.getName();
        if (moduleName.equals("wso2wsas-admin") || moduleName.equals("wso2tracer") || moduleName.equals("wso2statistics")) {
            return;
        }
        int eventType = axisEvent.getEventType();
        if (eventType == 5) {
            return;
        }
        String moduleVersion = axisModule.getVersion();
        if (moduleVersion == null) {
            moduleVersion = "";
        }
        if ((moduleDO = this.persistenceMgr.getModule(moduleName, moduleVersion)) != null) {
            try {
                this.persistenceMgr.handleExistingModuleInit(moduleDO, axisModule);
            }
            catch (Exception e) {
                log.error((Object)"Could not handle initialization of existing module", (Throwable)e);
            }
        } else {
            try {
                this.persistenceMgr.handleNewModuleAddition(axisModule, moduleName, moduleVersion);
            }
            catch (Exception e) {
                log.error((Object)"Could not handle addition of new module", (Throwable)e);
            }
        }
    }

    public void addParameter(Parameter parameter) throws AxisFault {
        this.paramMap.put(parameter.getName(), parameter);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.paramMap.remove(param.getName());
    }

    public void deserializeParameters(OMElement omElement) throws AxisFault {
    }

    public Parameter getParameter(String paramName) {
        return (Parameter)this.paramMap.get(paramName);
    }

    public ArrayList getParameters() {
        Collection collection = this.paramMap.values();
        ArrayList arr = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arr.add(iterator.next());
        }
        return arr;
    }

    public boolean isParameterLocked(String paramName) {
        return ((Parameter)this.paramMap.get(paramName)).isLocked();
    }
}

