/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.io.File;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.TomcatRepositoryListener;
import org.wso2.wsas.TomcatServerCache;
import org.wso2.wsas.WebServer;

public class TomcatServer
implements WebServer {
    private static Log log = LogFactory.getLog((Class)TomcatServer.class);
    public static final Embedded embedded = TomcatServerCache.getEmbedded();

    public void start() throws Exception {
        File samples;
        String wso2wsasHome = System.getProperty("wso2wsas.home");
        String catalinaHome = new File(wso2wsasHome).getAbsolutePath() + File.separator + "lib" + File.separator + "tomcat";
        embedded.setCatalinaHome(catalinaHome);
        String webappsDir = catalinaHome + File.separator + "webapps";
        String docsDir = wso2wsasHome + File.separator + "docs";
        String samplesDir = wso2wsasHome + File.separator + "samples";
        MemoryRealm memRealm = new MemoryRealm();
        embedded.setRealm((Realm)memRealm);
        Engine engine = embedded.createEngine();
        engine.setName("Catalina");
        engine.setDefaultHost(NetworkUtils.getLocalHostname());
        embedded.addEngine(engine);
        Host defaultHost = embedded.createHost(NetworkUtils.getLocalHostname(), webappsDir);
        engine.addChild((Container)defaultHost);
        File docs = new File(docsDir);
        if (docs.exists()) {
            Context docsContext = embedded.createContext("/docs", docs.getAbsolutePath());
            defaultHost.addChild((Container)docsContext);
        }
        if ((samples = new File(samplesDir)).exists()) {
            Context samplesContext = embedded.createContext("/samples", samples.getAbsolutePath());
            defaultHost.addChild((Container)samplesContext);
        }
        defaultHost.setDeployOnStartup(true);
        defaultHost.setAutoDeploy(true);
        embedded.setUseNaming(true);
        embedded.start();
        try {
            TomcatRepositoryListener tomcatRepositoryListener = new TomcatRepositoryListener(embedded, defaultHost, new File(webappsDir).getAbsolutePath());
            new Thread(tomcatRepositoryListener).start();
        }
        catch (Exception e) {
            log.error((Object)"Cannot start Tomcat repository listener", (Throwable)e);
        }
    }

    public void stop() throws Exception {
        embedded.stop();
    }
}

