/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.utils.FileManipulator;

public class TomcatRepositoryListener
implements Runnable {
    private static Log log = LogFactory.getLog((Class)TomcatRepositoryListener.class);
    private Map repoMap = new HashMap();
    private Embedded embedded;
    private Host host;
    private File repo;
    private ArchiveManipulator arcMan = new ArchiveManipulator();
    private FileManipulator fileMan = new FileManipulator();

    public TomcatRepositoryListener(Embedded embedded, Host host, String repo) throws Exception {
        this.embedded = embedded;
        this.host = host;
        this.repo = new File(repo);
        if (!this.repo.isDirectory()) {
            this.repo = null;
            throw new Exception(repo + " is not a directory");
        }
    }

    public void run() {
        while (true) {
            File[] files = this.repo.listFiles();
            ArrayList<String> c = new ArrayList<String>();
            if (files != null) {
                String filename;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    filename = file.getName();
                    c.add(filename);
                    if (this.repoMap.containsKey(filename)) {
                        long timestamp = ((WebContext)this.repoMap.get(filename)).getTimestamp();
                        if (timestamp >= file.lastModified() || !filename.endsWith(".war")) continue;
                        String dirName = filename.substring(0, filename.indexOf(".war"));
                        this.fileMan.deleteDir(new File(this.repo.getAbsolutePath() + File.separator + dirName));
                        try {
                            this.arcMan.extract(this.repo.getAbsolutePath() + File.separator + filename, this.repo.getAbsolutePath() + File.separator + dirName);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        WebContext webContext = (WebContext)this.repoMap.get(filename);
                        webContext.setTimestamp(file.lastModified());
                        this.repoMap.put(filename, webContext);
                        continue;
                    }
                    if (file.isDirectory()) {
                        Context context;
                        if (filename.equals("ROOT")) {
                            context = this.embedded.createContext("/", file.getAbsolutePath());
                            this.host.addChild((Container)context);
                        } else {
                            context = this.embedded.createContext("/" + filename, file.getAbsolutePath());
                            this.host.addChild((Container)context);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Deployed Web application: " + filename));
                        }
                        this.repoMap.put(filename, new WebContext(file.lastModified(), context));
                        continue;
                    }
                    if (!filename.endsWith(".war")) continue;
                    try {
                        this.arcMan.extract(this.repo.getAbsolutePath() + File.separator + filename, this.repo.getAbsolutePath() + File.separator + filename.substring(0, filename.indexOf(".war")));
                        this.repoMap.put(filename, new WebContext(file.lastModified(), null));
                        continue;
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception occurred while extracting archive " + filename), (Throwable)e);
                    }
                }
                ArrayList<String> toRemove = new ArrayList<String>();
                Iterator<Object> iterator = this.repoMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Context context;
                    filename = (String)iterator.next();
                    if (c.contains(filename) || (context = ((WebContext)this.repoMap.get(filename)).getContext()) == null) continue;
                    this.host.removeChild((Container)context);
                    toRemove.add(filename);
                    log.info((Object)("Undeployed Web application " + filename));
                }
                iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    this.repoMap.remove(iterator.next());
                }
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)"TomcatRepositoryListener thread was interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private static class WebContext {
        private long timestamp;
        private Context context;

        public WebContext(long timestamp, Context context) {
            this.timestamp = timestamp;
            this.context = context;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Context getContext() {
            return this.context;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

