/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.io.File;
import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerConfigurator;
import org.wso2.utils.ServerException;
import org.wso2.utils.WSO2ConfigurationContextFactory;
import org.wso2.wsas.ServerInitializer;
import org.wso2.wsas.ServerStatus;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.exception.KeyStoreAlreadyExistsException;
import org.wso2.wsas.util.KeyStoreUtil;
import org.wso2.wsas.util.LoggingUtil;
import org.wso2.wsas.util.Monitor;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.WsasUtils;

public final class ServerManager {
    private static final Log log = LogFactory.getLog((Class)ServerManager.class);
    public String axis2RepoLocation;
    public Monitor monitor;
    public ConfigurationContext configContext;
    public String serverWorkDir;
    public String adminResourceBase;
    private ServerConfiguration serverConfig = ServerConfiguration.getInstance();
    private static ServerManager instance;
    private ListenerManager listenerManager;
    private int httpPort = 10001;
    private int httpsPort = 11001;

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    private ServerManager() {
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void start() throws ServerException {
        try {
            AxisConfiguration axisConfig;
            ServerConfigurator serverConfigurator = ServerConfigurator.getInstance();
            serverConfigurator.cleanup();
            if (!serverConfigurator.isInitialized()) {
                serverConfigurator.init(this.axis2RepoLocation, System.getProperty("web.location"));
            }
            this.initLoggingConfiguration();
            this.persistSecurityKeyStore();
            ConfigurationContext oldContext = this.configContext;
            if (oldContext != null) {
                ListenerManager.getDefaultListenerManager().stop();
            }
            this.configContext = WSO2ConfigurationContextFactory.createNewConfigurationContext((AxisConfigurator)ServerConfigurator.getInstance());
            if (!WsasUtils.isAdminConsoleEnabled() && (axisConfig = this.configContext.getAxisConfiguration()).getServiceGroup("wso2wsas-administration") != null) {
                axisConfig.removeServiceGroup("wso2wsas-administration");
            }
            if (oldContext != null) {
                ClusterManager originalClusterManager = oldContext.getAxisConfiguration().getClusterManager();
                this.configContext.getAxisConfiguration().setClusterManager(originalClusterManager);
            }
            this.initNetworkUtils(this.configContext.getAxisConfiguration());
            this.runIntializers();
            try {
                ServerStatus.setServerRunning();
            }
            catch (AxisFault e) {
                String msg = "Cannot set server to running mode";
                log.error((Object)msg, (Throwable)e);
            }
        }
        catch (Exception e) {
            String msg = "Cannot start WSO2 WSAS";
            log.fatal((Object)msg, (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    private void persistSecurityKeyStore() throws ServerException {
        String ksLocation = this.serverConfig.getFirstProperty("Security.KeyStore.Location");
        if (!KeyStoreUtil.keyStoreExists(ksLocation)) {
            try {
                KeyStoreUtil.persistKeyStore(new File(ksLocation).getAbsolutePath(), this.serverConfig.getFirstProperty("Security.KeyStore.Password"), this.serverConfig.getFirstProperty("Security.KeyStore.Type"), this.serverConfig.getFirstProperty("Security.KeyStore.KeyAlias"), this.serverConfig.getFirstProperty("Security.KeyStore.KeyPassword"), null, true);
            }
            catch (KeyStoreAlreadyExistsException e) {
                throw new ServerException((Throwable)e);
            }
        }
    }

    public void status() {
    }

    public void stop() {
    }

    private void initLoggingConfiguration() {
        String isLoaded = new PersistenceManager().getConfigurationProperty("wso2wsas.system.log.is.loaded");
        if (Boolean.valueOf(isLoaded).booleanValue()) {
            LoggingUtil.loadCustomConfiguration();
        } else {
            LoggingUtil.loadDefaultConfiguration();
        }
    }

    public void startListenerManager() {
        this.listenerManager = new ListenerManager();
        this.listenerManager.startSystem(this.configContext);
        ListenerManager.defaultConfigurationContext = this.configContext;
    }

    public void stopListenerManager() throws AxisFault {
        try {
            if (this.listenerManager != null) {
                this.listenerManager.destroy();
            }
            if (this.configContext != null) {
                this.configContext.terminate();
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while shutting down listeners", (Throwable)e);
        }
    }

    private void runIntializers() throws ServerException {
        String[] initializers = this.serverConfig.getProperties("ServerInitializers.Initializer");
        for (int i = 0; i < initializers.length; ++i) {
            String clazzName = initializers[i];
            try {
                Class<?> clazz = Class.forName(clazzName);
                ServerInitializer intializer = (ServerInitializer)clazz.newInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using ServerInitializer " + intializer.getClass().getName()));
                }
                intializer.init(this.configContext);
                continue;
            }
            catch (Exception e) {
                throw new ServerException((Throwable)e);
            }
        }
    }

    private void initNetworkUtils(AxisConfiguration axisConfiguration) throws AxisFault, SocketException {
        String hostName = this.serverConfig.getFirstProperty("HostName");
        if (hostName != null) {
            Parameter param = axisConfiguration.getParameter("hostname");
            if (param != null) {
                param.setEditable(true);
                param.setValue((Object)hostName);
            } else {
                param = ParameterUtil.createParameter("hostname", hostName);
                axisConfiguration.addParameter(param);
            }
        } else {
            Parameter param = axisConfiguration.getParameter("hostname");
            if (param != null) {
                hostName = (String)param.getValue();
                log.info((Object)"hostname has been selected from Axis2.xml.");
            }
        }
        NetworkUtils.init((String)hostName);
    }
}

