/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ManagementFactory;

public class ServerManagement {
    private static final Log log = LogFactory.getLog((Class)ServerManagement.class);
    private static final long TIMEOUT = 60000L;
    private Map inTransports;

    public ServerManagement(Map inTransports) {
        this.inTransports = inTransports;
    }

    public ServerManagement() {
    }

    public void startMaintenance() throws Exception {
        log.info((Object)"Starting to switch to maintenance mode...");
        Iterator iter = this.inTransports.values().iterator();
        while (iter.hasNext()) {
            TransportInDescription tinDesc = (TransportInDescription)iter.next();
            TransportListener transport = tinDesc.getReceiver();
            transport.stop();
        }
        log.info((Object)"Stopped all transport listeners");
        log.info((Object)"Waiting for request service completion...");
        this.waitForRequestCompletion();
        log.info((Object)"All requests have been served.");
    }

    public void waitForRequestCompletion() throws Exception {
        boolean areRequestsInService;
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        long start = System.currentTimeMillis();
        do {
            QueryExp q;
            Set<ObjectName> set;
            if ((set = mbs.queryNames(new ObjectName("Catalina:type=RequestProcessor,*"), q = Query.eq(Query.attr("stage"), Query.value(3)))).size() > 0) {
                areRequestsInService = true;
                if (System.currentTimeMillis() - start > 60000L) {
                    log.warn((Object)"Timeout occurred even though there are active connections.");
                    break;
                }
                Thread.sleep(2000L);
                continue;
            }
            areRequestsInService = false;
        } while (areRequestsInService);
    }

    public void endMaintenance() throws Exception {
        log.info((Object)"Switching to normal mode...");
        Iterator iter = this.inTransports.values().iterator();
        while (iter.hasNext()) {
            TransportInDescription tinDesc = (TransportInDescription)iter.next();
            TransportListener transport = tinDesc.getReceiver();
            transport.start();
        }
        log.info((Object)"Switched to normal mode");
    }
}

