/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.adminui.AdminUIServletFilter;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerConfigurationException;
import org.wso2.utils.ServerException;
import org.wso2.utils.transport.ProxyCache;
import org.wso2.wsas.ServerManagement;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.ServerStatus;
import org.wso2.wsas.serverinfo.ServerInfo;
import org.wso2.wsas.util.ClusteringUtil;
import org.wso2.wsas.util.Controllable;
import org.wso2.wsas.util.MIMEType2FileExtensionMap;
import org.wso2.wsas.util.Monitor;
import org.wso2.wsas.util.ServerController;
import org.wso2.wsas.util.SystemRestarter;
import org.wso2.wsas.util.WsasUtils;

public class MainServlet
extends HttpServlet
implements Controllable {
    private static final Log log = LogFactory.getLog((Class)MainServlet.class);
    private static final long serialVersionUID = 4517849288538613640L;
    protected ServerManager serverManager;
    protected String serverName;
    private ServletConfig servletConfig;
    private String wso2wsasHome;
    private ServerConfiguration serverConfig;
    private Thread shutdownHook;
    private ServerController serverController;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServerInfo serverInfo;
        Properties props;
        long startTime = System.getProperty("wso2wsas.start.time") == null ? System.currentTimeMillis() : Long.parseLong(System.getProperty("wso2wsas.start.time"));
        this.servletConfig = servletConfig;
        try {
            System.setProperty("web.location", servletConfig.getServletContext().getRealPath("/wservices"));
        }
        catch (Exception e) {
            log.warn((Object)"wso2wsas.war is not expanded. Web content within AAR file not supported.");
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("wso2wsas.properties");
            props = new Properties();
            if (is == null) {
                String msg = "wso2wsas.properties file not found in classpath";
                log.fatal((Object)msg);
                log.fatal((Object)(this.serverName + " startup failed."));
                throw new ServletException(msg);
            }
            props.load(is);
            is.close();
        }
        catch (IOException e) {
            String msg = "wso2wsas.properties file cannot be read";
            log.fatal((Object)msg, (Throwable)e);
            log.fatal((Object)(this.serverName + " startup failed."));
            throw new ServletException(msg, (Throwable)e);
        }
        this.wso2wsasHome = System.getProperty("wso2wsas.home");
        if (this.wso2wsasHome == null) {
            this.wso2wsasHome = props.getProperty("wso2wsas.home");
            if (this.wso2wsasHome == null) {
                String msg = "wso2wsas.home property not set in wso2wsas.properties file";
                log.fatal((Object)msg);
                log.fatal((Object)(this.serverName + " startup failed."));
                throw new ServletException(msg);
            }
        }
        System.setProperty("axis2.home", this.wso2wsasHome);
        System.setProperty("wso2wsas.home", this.wso2wsasHome);
        this.serverConfig = ServerConfiguration.getInstance();
        try {
            this.serverConfig.init(WsasUtils.getWsasServerXml());
        }
        catch (ServerConfigurationException e) {
            String msg = "Could not initialize server configuration";
            log.fatal((Object)msg);
            log.fatal((Object)(this.serverName + " startup failed."));
            throw new ServletException(msg);
        }
        this.serverManager = ServerManager.getInstance();
        this.serverName = this.serverConfig.getFirstProperty("Name");
        File file = new File(this.wso2wsasHome);
        if (!file.exists()) {
            String msg = "wso2wsas.home " + this.wso2wsasHome + " does not exist.";
            log.fatal((Object)msg);
            log.fatal((Object)(this.serverName + " startup failed."));
            throw new ServletException(msg);
        }
        if (!file.isDirectory()) {
            String msg = "wso2wsas.home " + this.wso2wsasHome + " is not a directory.";
            log.fatal((Object)msg);
            log.fatal((Object)(this.serverName + " startup failed."));
            throw new ServletException(msg);
        }
        String serverInfoImplClass = props.getProperty("server.info.impl");
        log.info((Object)("Using Server Info Class: " + serverInfoImplClass));
        try {
            serverInfo = (ServerInfo)Class.forName(serverInfoImplClass).newInstance();
            serverInfo.setProperties(props);
        }
        catch (Exception e) {
            String msg = "Could not instantiate ServerInfo implementation class " + serverInfoImplClass;
            log.fatal((Object)msg, (Throwable)e);
            log.fatal((Object)(this.serverName + " startup failed."));
            throw new ServletException(msg);
        }
        try {
            this.start(servletConfig);
        }
        catch (ServerException e) {
            String msg = "Could not start " + this.serverName;
            log.fatal((Object)msg, (Throwable)e);
            throw new ServletException(msg);
        }
        ConfigurationContext configCtx = this.serverManager.configContext;
        this.serverManager.startListenerManager();
        serverInfo.process();
        ServerManager.getInstance().setHttpPort(serverInfo.getHttpPort());
        ServerManager.getInstance().setHttpsPort(serverInfo.getHttpsPort());
        WsasUtils.setServletContextProperties(servletConfig.getServletContext(), (Map)configCtx.getProperty("local_wso2wsas.generated.pages"), WsasUtils.isAdminConsoleEnabled(), ProxyCache.getInstance().getHttpPort() != -1 ? ProxyCache.getInstance().getHttpPort() : ServerManager.getInstance().getHttpPort(), ProxyCache.getInstance().getHttpsPort() != -1 ? ProxyCache.getInstance().getHttpsPort() : ServerManager.getInstance().getHttpsPort(), configCtx.getServicePath());
        this.printInfo(startTime);
        System.getProperties().remove("wso2wsas.start.time");
    }

    public void start(ServletConfig servletConfig) throws ServerException {
        ServletContext servletContext = servletConfig.getServletContext();
        System.setProperty("derby.system.home", new File(this.serverConfig.getFirstProperty("Database.Home")).getAbsolutePath());
        String hostName = ServerConfiguration.getInstance().getFirstProperty("ClusteringHostName");
        if (System.getProperty("axis2.local.ip.address") == null && hostName != null && hostName.trim().length() != 0) {
            System.setProperty("axis2.local.ip.address", hostName);
        }
        this.serverManager.adminResourceBase = servletContext.getRealPath(".");
        if (this.serverManager.adminResourceBase == null) {
            this.serverManager.adminResourceBase = "TODO";
        }
        this.serverManager.serverWorkDir = new File(this.serverConfig.getFirstProperty("WorkDirectory")).getAbsolutePath();
        System.setProperty("axis2.work.dir", this.serverManager.serverWorkDir);
        this.serverManager.axis2RepoLocation = this.serverConfig.getFirstProperty("Axis2Config.RepositoryLocation");
        if (!this.serverManager.axis2RepoLocation.endsWith("/")) {
            this.serverConfig.setConfigurationProperty("Axis2Config.RepositoryLocation", this.serverManager.axis2RepoLocation + "/");
            this.serverManager.axis2RepoLocation = this.serverManager.axis2RepoLocation + "/";
        }
        System.setProperty("axis2.repo", this.serverManager.axis2RepoLocation);
        MIMEType2FileExtensionMap.mappingFileName = this.wso2wsasHome + File.separator + "conf" + File.separator + "mime-mappings.xml";
        try {
            this.serverManager.start();
            this.addShutdownHook();
            ConfigurationContext configCtx = this.serverManager.configContext;
            servletConfig.getServletContext().setAttribute("CONFIGURATION_CONTEXT", (Object)configCtx);
            configCtx.setProperty("ContainerManaged", (Object)"true");
            configCtx.setProperty("WORK_DIR", (Object)this.serverManager.serverWorkDir);
            configCtx.setProperty("local_WSO2_WSAS", (Object)this);
            this.startServerController();
        }
        catch (Exception e) {
            throw new ServerException(this.serverName + " startup failed.", (Throwable)e);
        }
    }

    private void printInfo(long startTime) {
        int httpsPort;
        int httpPort = ServerManager.getInstance().getHttpPort();
        if (httpPort != -1) {
            log.info((Object)("HTTP port            : " + httpPort));
        }
        if ((httpsPort = ServerManager.getInstance().getHttpsPort()) != -1) {
            log.info((Object)("HTTPS port           : " + httpsPort));
        }
        log.info((Object)"");
        log.info((Object)(this.serverName + " started in " + (System.currentTimeMillis() - startTime) + " ms"));
    }

    private void addShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new Thread(){

            public void run() {
                log.info((Object)("Shutting down " + MainServlet.this.serverName + "..."));
                try {
                    new ServerManagement(MainServlet.this.serverManager.configContext.getAxisConfiguration().getTransportsIn()).startMaintenance();
                    MainServlet.this.cleanupSystem();
                    try {
                        MainServlet.this.serverManager.stopListenerManager();
                    }
                    catch (AxisFault e) {
                        String msg = "Error occurred while stopping Axis2 Listener Manager";
                        log.error((Object)msg, (Throwable)e);
                        throw new ServerException(msg, (Throwable)e);
                    }
                    log.info((Object)"Shutdown complete");
                    log.info((Object)"Halting JVM");
                }
                catch (Exception e) {
                    log.warn((Object)"Error occurred while shutting down WSO2 WSAS", (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void setAxis2RepoLocation(String axis2RepoLocation) {
        this.serverManager.axis2RepoLocation = axis2RepoLocation;
    }

    public void setMonitor(Monitor monitor) {
        this.serverManager.monitor = monitor;
    }

    public void startServer() throws ServerException {
        try {
            this.init(this.servletConfig);
            this.reinitializeServlets(this.servletConfig.getServletContext());
            try {
                ServerStatus.setServerRunning();
            }
            catch (AxisFault e) {
                String msg = "Cannot set server to running mode";
                log.error((Object)msg, (Throwable)e);
            }
        }
        catch (ServletException e) {
            String msg = "Cannot start server";
            log.fatal((Object)msg, (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    public void stopListeners() throws ServerException {
    }

    public void restart() {
        try {
            ServerStatus.setServerRestarting();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to restarting mode";
            log.error((Object)msg, (Throwable)e);
        }
        SystemRestarter st = new SystemRestarter(false, this, this, this.serverManager.axis2RepoLocation, this.serverManager.monitor);
        this.cleanupSystem();
        new Thread(st).start();
    }

    public void restartGracefully() {
        try {
            ServerStatus.setServerRestarting();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to restarting mode";
            log.error((Object)msg, (Throwable)e);
        }
        SystemRestarter st = new SystemRestarter(true, this, this, this.serverManager.axis2RepoLocation, this.serverManager.monitor);
        this.cleanupSystem();
        new Thread(st).start();
    }

    public void shutdown() {
        try {
            ServerStatus.setServerShuttingDown();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to shutdown mode";
            log.error((Object)msg, (Throwable)e);
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        System.exit(0);
    }

    public void shutdownGracefully() {
        try {
            ServerStatus.setServerShuttingDown();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to shutdown mode";
            log.error((Object)msg, (Throwable)e);
        }
        System.exit(0);
    }

    public Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public void setConfigurationContext(ConfigurationContext newConfigCtx) throws ServerException {
        try {
            ContextManager contextManager;
            ConfigurationContext oldConfigCtx = this.serverManager.configContext;
            AxisConfiguration oldAxisConfig = oldConfigCtx.getAxisConfiguration();
            ClusterManager originalClusterManager = oldAxisConfig.getClusterManager();
            newConfigCtx.getAxisConfiguration().setClusterManager(originalClusterManager);
            Iterator iter = oldConfigCtx.getPropertyNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                newConfigCtx.setProperty(key, oldConfigCtx.getProperty(key));
            }
            originalClusterManager.setConfigurationContext(newConfigCtx);
            ConfigurationManager configurationManager = originalClusterManager.getConfigurationManager();
            if (configurationManager != null) {
                configurationManager.setConfigurationContext(newConfigCtx);
            }
            if ((contextManager = originalClusterManager.getContextManager()) != null) {
                contextManager.setConfigurationContext(newConfigCtx);
            }
            oldAxisConfig.setClusterManager(null);
            try {
                this.serverManager.stopListenerManager();
            }
            catch (AxisFault axisFault) {
                throw new ServerException((Throwable)axisFault);
            }
            this.serverManager.configContext = newConfigCtx;
            if (!WsasUtils.isAdminConsoleEnabled()) {
                newConfigCtx.getAxisConfiguration().removeServiceGroup("wso2wsas-administration");
            }
            ServletContext servletContext = this.servletConfig.getServletContext();
            servletContext.removeAttribute("CONFIGURATION_CONTEXT");
            servletContext.setAttribute("CONFIGURATION_CONTEXT", (Object)newConfigCtx);
            this.reinitializeServlets(servletContext);
            try {
                ClusteringUtil.enableClustering(newConfigCtx);
            }
            catch (AxisFault axisFault) {
                throw new ServerException((Throwable)axisFault);
            }
            this.serverManager.startListenerManager();
        }
        catch (Exception e) {
            String msg = "Cannot set ConfigurationContext";
            log.fatal((Object)msg, (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.serverManager.configContext;
    }

    private void reinitializeServlets(ServletContext servletContext) throws ServletException {
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attrib = servletContext.getAttribute((String)attributeNames.nextElement());
            if (attrib instanceof HttpServlet) {
                ((HttpServlet)attrib).init();
                continue;
            }
            if (!(attrib instanceof AdminUIServletFilter)) continue;
            AdminUIServletFilter adminUIServletFilter = (AdminUIServletFilter)attrib;
            adminUIServletFilter.init();
        }
    }

    private void startServerController() {
        if (this.serverController != null) {
            return;
        }
        this.serverController = new ServerController(this);
        int cmdListenerPort = WsasUtils.getCommandListenerPort();
        if (cmdListenerPort == -1) {
            return;
        }
        this.serverController.setPort(cmdListenerPort);
        Thread thread = new Thread(this.serverController);
        thread.start();
        log.info((Object)("Command port         : " + cmdListenerPort));
    }

    public void destroy() {
        try {
            this.shutdownGracefully();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while shutting down the system", (Throwable)e);
        }
    }

    private void cleanupSystem() {
        Object property;
        log.info((Object)"Cleaning up system...");
        new FileManipulator().deleteDir(new File(this.wso2wsasHome + File.separator + this.serverConfig.getFirstProperty("WorkDirectory")));
        ConfigurationContext configContext = this.serverManager.configContext;
        if (configContext != null && (property = configContext.getProperty("file.resource.map")) != null) {
            ((Map)property).clear();
        }
    }
}

