/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerConfigurationException;
import org.wso2.utils.ServerException;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.TomcatServer;
import org.wso2.wsas.WebServer;
import org.wso2.wsas.util.Monitor;
import org.wso2.wsas.util.ServerController;
import org.wso2.wsas.util.WsasUtils;
import org.wso2.wsas.util.XmlConfiguration;

public class Main {
    private static final Log log = LogFactory.getLog((Class)Main.class);
    public static final String COMMAND_START = "START";
    public static final String COMMAND_RESTART = "RESTART";
    public static final String COMMAND_STOP = "STOP";
    public static final String COMMAND_RUN = "RUN";
    public static final String COMMAND_STATUS = "STATUS";
    public static final String COMMAND_VERSION = "VERSION";
    public static final String COMMAND_DEBUG = "DEBUG";
    public static Thread shutdownHookThread;
    private WebServer webServer;
    private static ServerConfiguration serverConfig;
    public static XmlConfiguration xmlConfiguration;

    public Main() {
        if (System.getProperty("wso2wsas.home") == null) {
            System.setProperty("wso2wsas.home", ".");
            System.setProperty("axis2.home", ".");
        } else {
            System.setProperty("axis2.home", System.getProperty("wso2wsas.home"));
        }
        String serverXMLLocation = WsasUtils.getWsasServerXml();
        try {
            serverConfig = ServerConfiguration.getInstance();
            serverConfig.init(serverXMLLocation);
        }
        catch (ServerConfigurationException e) {
            throw new RuntimeException(e);
        }
        if (System.getProperty("derby.system.home") == null) {
            System.setProperty("derby.system.home", serverConfig.getFirstProperty("Database.Home"));
        }
    }

    public void startServer() {
        try {
            this.webServer = new TomcatServer();
            this.webServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws IOException, ServerException {
        ServerManager.getInstance().stop();
        this.stopListeners();
    }

    public void status() throws IOException {
        ServerManager.getInstance().status();
    }

    public void shutdown() throws ServerException {
        this.stopListeners();
        this.cleanupSystem();
    }

    public static void main(String[] args) {
        String msg;
        System.setProperty("wso2wsas.start.time", String.valueOf(System.currentTimeMillis()));
        String cmd = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-D")) {
                String value;
                String property;
                int indexOfEq = arg.indexOf("=");
                if (indexOfEq != -1) {
                    property = arg.substring(2, indexOfEq);
                    value = arg.substring(indexOfEq + 1);
                } else {
                    property = arg.substring(2);
                    value = "true";
                }
                System.setProperty(property, value);
                continue;
            }
            if (cmd == null) {
                cmd = arg;
                continue;
            }
            if (cmd.toUpperCase().endsWith(COMMAND_DEBUG)) continue;
            Main.printUsages();
            return;
        }
        if (cmd == null) {
            cmd = COMMAND_RUN;
        }
        Main main = new Main();
        String serverName = serverConfig.getFirstProperty("Name");
        if (cmd.toUpperCase().endsWith(COMMAND_START) || cmd.toUpperCase().endsWith(COMMAND_RUN) || cmd.toUpperCase().endsWith(COMMAND_DEBUG)) {
            if (cmd.toUpperCase().endsWith(COMMAND_DEBUG)) {
                log.info((Object)("Starting " + serverName + " " + serverConfig.getFirstProperty("Version") + " (Powered by Apache Axis2) in debug mode"));
            } else {
                log.info((Object)("Starting " + serverName + " " + serverConfig.getFirstProperty("Version") + " (Powered by Apache Axis2)"));
            }
            log.info((Object)("Using Java Home        : " + System.getProperty("java.home")));
            log.info((Object)("Using Java Version     : " + System.getProperty("java.version")));
            log.info((Object)("Using " + serverName + " Home   : " + System.getProperty("wso2wsas.home")));
            main.startServer();
        } else if (cmd.toUpperCase().endsWith(COMMAND_RESTART)) {
            try {
                ServerController serverController = new ServerController();
                serverController.setPort(WsasUtils.getCommandListenerPort());
                serverController.restartServer();
            }
            catch (Exception e) {
                msg = "Cannot restart " + serverName;
                log.error((Object)msg, (Throwable)e);
            }
        } else if (cmd.toUpperCase().endsWith(COMMAND_STOP)) {
            try {
                ServerController serverController = new ServerController();
                serverController.setPort(WsasUtils.getCommandListenerPort());
                serverController.shutDownServer();
            }
            catch (Exception e) {
                msg = "Cannot stop " + serverName;
                log.error((Object)msg, (Throwable)e);
            }
        } else if (cmd.toUpperCase().endsWith(COMMAND_VERSION)) {
            System.out.println(serverName + " version: " + serverConfig.getFirstProperty("Version"));
        } else if (cmd.toUpperCase().endsWith(COMMAND_STATUS)) {
            try {
                main.status();
            }
            catch (IOException e) {
                msg = "Cannot get status of " + serverName;
                log.error((Object)msg, (Throwable)e);
            }
        } else {
            Main.printUsages();
        }
    }

    private static void printUsages() {
        String serverName = serverConfig.getFirstProperty("Name");
        System.out.println("Usage: " + System.getProperty("server.script") + " [command]");
        System.out.println("command:");
        System.out.println("\t--start\t\tStart " + serverName + " as a background process");
        System.out.println("\t--run\t\tRun " + serverName);
        System.out.println("\t--restart\tRestart " + serverName);
        System.out.println("\t--stop\t\tStop " + serverName);
        System.out.println("\t--debug <port> \tStart " + serverName + " in remote debugging mode." + "\n\t\t\tport: The remote debugging port.");
        System.out.println("\t--version\tWhat version of " + serverName + " are you running?");
        System.out.println();
    }

    public ConfigurationContext getConfigContext() {
        return ServerManager.getInstance().configContext;
    }

    public void setMonitor(Monitor m) {
        ServerManager.getInstance().monitor = m;
    }

    public void stopListeners() throws ServerException {
        if (this.webServer != null) {
            try {
                this.webServer.stop();
            }
            catch (Exception axisFault) {
                throw new ServerException((Throwable)axisFault);
            }
        }
        this.webServer = null;
    }

    private void cleanupSystem() {
        Object property;
        log.info((Object)"Cleaning up system...");
        new FileManipulator().deleteDir(new File(serverConfig.getFirstProperty("WorkDirectory")));
        ConfigurationContext configContext = ServerManager.getInstance().configContext;
        if (configContext != null && (property = configContext.getProperty("file.resource.map")) != null) {
            ((Map)property).clear();
        }
    }
}

