/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas;

import java.io.File;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.wso2.adminui.UIProcessingException;
import org.wso2.adminui.UIProcessor;
import org.wso2.tracer.module.TracePersister;
import org.wso2.utils.ManagementFactory;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.ServerInitializer;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.dataobject.TransportDO;
import org.wso2.wsas.persistence.exception.SecurityScenarioAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServiceUserAlreadyExistsException;
import org.wso2.wsas.persistence.exception.TransportAlreadyExistsException;
import org.wso2.wsas.persistence.exception.UserRoleAlreadyExistsException;
import org.wso2.wsas.security.WSASJMXAuthenticator;
import org.wso2.wsas.util.ClusteringUtil;
import org.wso2.wsas.util.HouseKeepingTask;
import org.wso2.wsas.util.XmlConfiguration;

public class DefaultServerInitializer
implements ServerInitializer {
    private static final Log log = LogFactory.getLog((Class)DefaultServerInitializer.class);
    private ServerConfiguration serverConfig = ServerConfiguration.getInstance();
    private PersistenceManager pm;
    private String wso2wsasHome;
    private static Logger rootLogger = Logger.getRootLogger();
    private boolean isHouseKeepingTaskCreated;
    private Timer houseKeepingTimer;
    private ServerManager serverManager = ServerManager.getInstance();
    private static boolean isJMXServiceStarted;

    public DefaultServerInitializer() {
        this.pm = new PersistenceManager();
    }

    public void init(ConfigurationContext configurationContext) throws AxisFault, ServerException {
        this.wso2wsasHome = System.getProperty("wso2wsas.home");
        this.initHouseKeeping();
        this.enableClustering(configurationContext);
        this.generatePages(configurationContext);
        Parameter enableHttp = new Parameter("enableHTTP", (Object)"true");
        AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
        axisConfig.addParameter(enableHttp);
        configurationContext.setProperty("MemoryAppender", (Object)rootLogger.getAppender("WSO2WSAS_MEMORY"));
        this.createDefaultServiceUserRoles();
        this.createDefaultAdminAccount();
        this.handleGlobalModuleEngagements(axisConfig);
        this.initServiceGroupContextTimeout(configurationContext);
        this.registerHouseKeepingTask(configurationContext);
        this.persistSecurityScenarios(configurationContext);
        this.initKeystoresDir();
        this.enableSoapTracing(axisConfig);
        this.persistTransports(axisConfig);
        log.info((Object)"");
        log.info((Object)("Repository           : " + this.serverManager.axis2RepoLocation));
        this.startJMXService();
    }

    private void startJMXService() throws ServerException {
        String jmxPort = ServerConfiguration.getInstance().getFirstProperty("Ports.JMX");
        if (jmxPort != null) {
            if (isJMXServiceStarted) {
                return;
            }
            int jmxPortInt = Integer.parseInt(jmxPort);
            MBeanServer mbs = ManagementFactory.getMBeanServer();
            try {
                LocateRegistry.createRegistry(jmxPortInt);
                String jmxURL = "service:jmx:rmi:///jndi/rmi://" + NetworkUtils.getLocalHostname() + ":" + jmxPortInt + "/server";
                JMXServiceURL url = new JMXServiceURL(jmxURL);
                HashMap<String, WSASJMXAuthenticator> env = new HashMap<String, WSASJMXAuthenticator>();
                env.put("jmx.remote.authenticator", new WSASJMXAuthenticator());
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
                cs.start();
                log.info((Object)("JMX Service URL      : " + jmxURL));
                isJMXServiceStarted = true;
            }
            catch (Exception e) {
                String msg = "Could not initialize MBean server";
                log.error((Object)msg, (Throwable)e);
                throw new ServerException(msg, (Throwable)e);
            }
        }
    }

    private void enableSoapTracing(AxisConfiguration axisConfig) throws AxisFault {
        AxisModule tracerModule = axisConfig.getModule("wso2tracer");
        if (tracerModule != null) {
            Parameter tracePersisterParam = axisConfig.getParameter("wso2tracer.trace.persister.impl");
            TracePersister tracePersister = null;
            if (tracePersisterParam != null) {
                Object tracePersisterImplObj = tracePersisterParam.getValue();
                if (tracePersisterImplObj instanceof TracePersister) {
                    tracePersister = (TracePersister)tracePersisterImplObj;
                } else if (tracePersisterImplObj instanceof String) {
                    try {
                        tracePersister = (TracePersister)Loader.loadClass((String)((String)tracePersisterImplObj).trim()).newInstance();
                    }
                    catch (Exception e) {
                        String message = "Cannot instatiate TracePersister ";
                        log.error((Object)message, (Throwable)e);
                        throw new RuntimeException(message, e);
                    }
                }
            } else {
                throw new AxisFault("wso2tracer.trace.persister.impl parameter not defined in axis2.xml");
            }
            if (tracePersister != null && tracePersister.isTracingEnabled()) {
                if (!axisConfig.isEngaged(tracerModule)) {
                    axisConfig.engageModule(tracerModule);
                }
            } else if (axisConfig.isEngaged(tracerModule)) {
                axisConfig.disengageModule(tracerModule);
            }
        }
    }

    private void enableClustering(ConfigurationContext configurationContext) throws AxisFault {
        ClusteringUtil.enableClustering(configurationContext);
    }

    private void generatePages(ConfigurationContext configurationContext) {
        block2: {
            Hashtable files = new Hashtable();
            try {
                UIProcessor.createPages((String)this.serverManager.adminResourceBase, (String)"ui-extensions-config.xml", files);
                configurationContext.setProperty("local_wso2wsas.generated.pages", files);
            }
            catch (UIProcessingException e) {
                String msg = "Static page generation failed";
                log.warn((Object)(msg + ": " + (Object)((Object)e)));
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)msg, (Throwable)e);
            }
        }
    }

    private void createDefaultServiceUserRoles() throws ServerException {
        OMElement document = this.serverConfig.getDocumentElement();
        Iterator surIte = document.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "ServiceUserRoles"));
        while (surIte.hasNext()) {
            OMElement serviceUserRoles = (OMElement)surIte.next();
            Iterator roleIte = serviceUserRoles.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Role"));
            while (roleIte.hasNext()) {
                OMElement role = (OMElement)roleIte.next();
                ServiceUserRoleDO serviceUserRole = null;
                Iterator nameIter = role.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Name"));
                while (nameIter.hasNext()) {
                    OMElement name = (OMElement)nameIter.next();
                    serviceUserRole = this.pm.getServiceUserRole(name.getText());
                    if (serviceUserRole != null) continue;
                    serviceUserRole = new ServiceUserRoleDO();
                    serviceUserRole.setRole(name.getText());
                }
                nameIter = role.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Description"));
                while (nameIter.hasNext()) {
                    OMElement description = (OMElement)nameIter.next();
                    if (serviceUserRole != null) {
                        serviceUserRole.setDescription(description.getText());
                        continue;
                    }
                    throw new ServerException("Description without a Role name is invalid");
                }
                try {
                    this.pm.addOrUpdateUserRole(serviceUserRole);
                }
                catch (UserRoleAlreadyExistsException ignored) {}
            }
        }
    }

    private void createDefaultAdminAccount() throws ServerException {
        String adminUsername = "admin";
        ServiceUserDO admin = this.pm.getUser(adminUsername);
        ServerConfiguration config = ServerConfiguration.getInstance();
        CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
        if (admin == null) {
            String adminPassword = this.getDefaultAdminPassword();
            String adminDescription = "Default Adminstrator";
            try {
                admin = new ServiceUserDO();
                admin.setUsername(adminUsername);
                admin.setPassword(cryptoUtil.encryptAndBase64Encode(adminPassword.getBytes()));
                admin.setDescription(adminDescription);
                ServiceUserRoleDO role = this.pm.getUserRole("admin");
                this.pm.addUser(admin);
                this.pm.addRole(admin.getUsername(), role);
            }
            catch (CryptoException e) {
                String msg = "Cannot encrypt default admin password";
                log.error((Object)msg, (Throwable)e);
                throw new ServerException(msg, (Throwable)e);
            }
            catch (ServiceUserAlreadyExistsException ignored) {}
        } else {
            try {
                if (new String(cryptoUtil.base64DecodeAndDecrypt(admin.getPassword())).equals("admin")) {
                    String password = this.getDefaultAdminPassword();
                    admin.setPassword(cryptoUtil.encryptAndBase64Encode(password.getBytes()));
                    this.pm.updateUser(admin);
                }
            }
            catch (Exception e) {
                throw new ServerException((Throwable)e);
            }
        }
    }

    private void persistTransports(AxisConfiguration axisConfig) throws AxisFault {
        PersistenceManager pm = new PersistenceManager();
        TransportDO[] transports = pm.getTransports();
        for (int i = 0; i < transports.length; ++i) {
            TransportDO transport = transports[i];
            if (axisConfig.getTransportIn(transport.getTransportProtocol()) != null) continue;
            if (!transport.getServices().isEmpty()) {
                String msg = "Cannot remove the " + transport.getTransportProtocol() + " transport.\n" + "\t\t\t\tOne or more services are bound to this transport. \n" + "\t\t\t\tAdd this transport back to the axis2.xml file and restart the server.";
                throw new AxisFault(msg);
            }
            pm.deleteEntity(transport);
        }
        Iterator transportsIter = axisConfig.getTransportsIn().values().iterator();
        while (transportsIter.hasNext()) {
            TransportInDescription tiDesc = (TransportInDescription)transportsIter.next();
            String protocolName = tiDesc.getName();
            if (pm.getTransport(protocolName) != null) continue;
            TransportDO transportDO = new TransportDO();
            transportDO.setTransportProtocol(protocolName);
            transportDO.setIsStarted(true);
            try {
                pm.addTransport(transportDO);
            }
            catch (TransportAlreadyExistsException ignored) {}
        }
    }

    private void handleGlobalModuleEngagements(AxisConfiguration axisConfig) throws ServerException {
        try {
            ModuleDO[] moduleDOs = this.pm.getAllModules();
            for (int i = 0; i < moduleDOs.length; ++i) {
                ModuleDO moduleDO = moduleDOs[i];
                if (!moduleDO.getIsGloballyEngaged()) continue;
                String moduleId = moduleDO.getModuleIdentifierDO().getName();
                if (!axisConfig.isEngaged(moduleId)) {
                    axisConfig.engageModule(moduleId);
                }
                if (!moduleId.equals("wso2throttle")) continue;
                axisConfig.getServiceGroup("wso2wsas-administration").disengageModule(axisConfig.getModule(moduleId));
            }
        }
        catch (Exception e) {
            String msg = Messages.getMessage((String)"CannotConfigureAxis2");
            log.error((Object)msg);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    private void initServiceGroupContextTimeout(ConfigurationContext configurationContext) {
        String serviceGroupContextIdleTimeout = this.serverConfig.getFirstProperty("Axis2Config.ServiceGroupContextIdleTime");
        if (serviceGroupContextIdleTimeout != null) {
            configurationContext.setProperty("ConfigContextTimeoutInterval", (Object)new Integer(serviceGroupContextIdleTimeout));
        }
    }

    private void registerHouseKeepingTask(ConfigurationContext configurationContext) {
        if (!this.isHouseKeepingTaskCreated && Boolean.valueOf(this.serverConfig.getFirstProperty("HouseKeeping.AutoStart")).booleanValue()) {
            this.houseKeepingTimer = new Timer();
            long houseKeepingInterval = Long.parseLong(this.serverConfig.getFirstProperty("HouseKeeping.Interval")) * 60L * 1000L;
            Object property = configurationContext.getProperty("file.resource.map");
            if (property == null) {
                property = new TreeBidiMap();
                configurationContext.setProperty("file.resource.map", property);
            }
            this.houseKeepingTimer.scheduleAtFixedRate((TimerTask)new HouseKeepingTask(this.serverManager.serverWorkDir, (BidiMap)property), houseKeepingInterval, houseKeepingInterval);
            this.isHouseKeepingTaskCreated = true;
        }
    }

    private void persistSecurityScenarios(ConfigurationContext configurationContext) throws ServerException {
        String scenarioConfigXml = this.wso2wsasHome + File.separator + "conf" + File.separator + "rampart" + File.separator + "scenario-config.xml";
        if (!new File(scenarioConfigXml).exists()) {
            log.info((Object)"Security scenario configuration file does not exist");
            return;
        }
        XmlConfiguration xmlConfiguration = new XmlConfiguration(scenarioConfigXml, "http://www.wso2.org/products/wsas/security");
        OMElement[] secenarioEle = xmlConfiguration.getElements("//ns:Scenario");
        for (int i = 0; i < secenarioEle.length; ++i) {
            SecurityScenarioDO scenario = new SecurityScenarioDO();
            OMElement omElement = secenarioEle[i];
            String scenarioId = omElement.getAttribute(ServerConstants.Security.ID_QN).getAttributeValue();
            if (this.pm.getSecurityScenario(scenarioId) != null) continue;
            scenario.setScenarioId(scenarioId);
            scenario.setSummary(omElement.getFirstChildWithName(ServerConstants.Security.SUMMARY_QN).getText());
            scenario.setDescription(omElement.getFirstChildWithName(ServerConstants.Security.DESCRIPTION_QN).getText());
            scenario.setCategory(omElement.getFirstChildWithName(ServerConstants.Security.CATEGORY_QN).getText());
            Iterator modules = omElement.getFirstChildWithName(ServerConstants.Security.MODULES_QN).getChildElements();
            while (modules.hasNext()) {
                String module = ((OMElement)modules.next()).getText();
                AxisModule axisModule = configurationContext.getAxisConfiguration().getModule(module);
                if (axisModule == null) continue;
                ModuleDO moduleDO = this.pm.getModule(axisModule.getName(), axisModule.getVersion());
                scenario.addModule(moduleDO);
            }
            try {
                this.pm.addSecurityScenario(scenario);
                continue;
            }
            catch (SecurityScenarioAlreadyExistsException ignored) {
                // empty catch block
            }
        }
    }

    private void initKeystoresDir() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String ksDirName = serverConfig.getFirstProperty("Security.KeyStoresDir");
        serverConfig.setConfigurationProperty("Security.KeyStoresDir", new File(ksDirName).getAbsolutePath());
    }

    private void initHouseKeeping() {
        if (this.houseKeepingTimer != null) {
            this.houseKeepingTimer.cancel();
            this.houseKeepingTimer = null;
            this.isHouseKeepingTaskCreated = false;
        }
    }

    private String getDefaultAdminPassword() {
        return "admin";
    }

    public void stopHouseKeeping() {
        this.initHouseKeeping();
    }
}

