/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.FailureLogger;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JavaDispatcher
implements EndpointDispatcher {
    private static final Log log = LogFactory.getLog(JavaDispatcher.class);
    protected Class serviceImplClass;
    protected Object serviceInstance;

    protected JavaDispatcher(Class impl, Object serviceInstance) {
        this.serviceImplClass = impl;
        this.serviceInstance = serviceInstance;
    }

    public abstract MessageContext invoke(MessageContext var1) throws Exception;

    public abstract void invokeOneWay(MessageContext var1);

    public abstract void invokeAsync(MessageContext var1, EndpointCallback var2);

    protected abstract MessageContext createResponse(MessageContext var1, Object[] var2, Object var3);

    protected abstract MessageContext createFaultResponse(MessageContext var1, Throwable var2);

    public Class getServiceImplementationClass() {
        return this.serviceImplClass;
    }

    protected Object invokeTargetOperation(Method method, Object[] params) throws Throwable {
        Object output = null;
        try {
            output = method.invoke(this.serviceInstance, params);
        }
        catch (Throwable t) {
            Throwable rootT = null;
            if (t instanceof InvocationTargetException) {
                rootT = ((InvocationTargetException)t).getTargetException();
            }
            FailureLogger.logError(rootT != null ? rootT : t, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception invoking a method of " + this.serviceImplClass.toString() + " of instance " + this.serviceInstance.toString()));
                log.debug((Object)("Exception type thrown: " + t.getClass().getName()));
                if (rootT != null) {
                    log.debug((Object)("Root Exception type thrown: " + rootT.getClass().getName()));
                }
                log.debug((Object)("Method = " + method.toGenericString()));
                for (int i = 0; i < params.length; ++i) {
                    String value = params[i] == null ? "null" : params[i].getClass().toString();
                    log.debug((Object)(" Argument[" + i + "] is " + value));
                }
            }
            throw t;
        }
        return output;
    }

    protected class AsyncInvocationWorker
    implements Callable {
        private Method method;
        private Object[] params;
        private ClassLoader classLoader;
        private EndpointInvocationContext eic;

        public AsyncInvocationWorker(Method m, Object[] p, ClassLoader cl, EndpointInvocationContext ctx) {
            this.method = m;
            this.params = p;
            this.classLoader = cl;
            this.eic = ctx;
        }

        public Object call() throws Exception {
            block17: {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invoking target endpoint via the async worker.");
                    }
                    ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
                    if (this.classLoader != null && this.classLoader != currentLoader) {
                        Thread.currentThread().setContextClassLoader(this.classLoader);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Context ClassLoader set to:" + this.classLoader));
                        }
                    }
                    Object output = null;
                    boolean faultThrown = false;
                    Throwable fault = null;
                    try {
                        output = JavaDispatcher.this.invokeTargetOperation(this.method, this.params);
                    }
                    catch (Exception e) {
                        fault = ClassUtils.getRootCause(e);
                        faultThrown = true;
                    }
                    if (this.eic.isOneWay()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Invocation pattern was one way, work complete.");
                        }
                        return null;
                    }
                    MessageContext request = this.eic.getRequestMessageContext();
                    MessageContext response = null;
                    if (faultThrown) {
                        response = JavaDispatcher.this.createFaultResponse(request, fault);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Async invocation of the endpoint was successful.  Creating response message.");
                        }
                        response = JavaDispatcher.this.createResponse(request, this.params, output);
                    }
                    EndpointInvocationContext eic = null;
                    if (request.getInvocationContext() != null) {
                        eic = (EndpointInvocationContext)request.getInvocationContext();
                        eic.setResponseMessageContext(response);
                    }
                    EndpointCallback callback = eic.getCallback();
                    boolean handleFault = response.getMessage().isFault();
                    if (!handleFault) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"No fault detected in response message, sending back application response.");
                        }
                        callback.handleResponse(eic);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"A fault was detected.  Sending back a fault response.");
                        }
                        callback.handleFaultResponse(eic);
                    }
                    Thread.currentThread().setContextClassLoader(currentLoader);
                    TransportUtils.deleteAttachments((org.apache.axis2.context.MessageContext)eic.getRequestMessageContext().getAxisMessageContext());
                    TransportUtils.deleteAttachments((org.apache.axis2.context.MessageContext)eic.getResponseMessageContext().getAxisMessageContext());
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block17;
                    log.debug((Object)"AN UNEXPECTED ERROR OCCURRED IN THE ASYNC WORKER THREAD");
                    log.debug((Object)("Exception is:" + e), e);
                }
            }
            return null;
        }
    }
}

