/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import java.io.Reader;
import java.io.StringReader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.ServiceInstanceFactory;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.axis2.jaxws.server.dispatcher.factory.EndpointDispatcherFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointController {
    private static final Log log = LogFactory.getLog(EndpointController.class);

    public EndpointInvocationContext invoke(EndpointInvocationContext eic) {
        block8: {
            boolean good;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invocation pattern: synchronous");
            }
            if (!(good = this.handleRequest(eic))) {
                return eic;
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            org.apache.axis2.jaxws.core.MessageContext response = null;
            try {
                EndpointDispatcher dispatcher = eic.getDispatcher();
                if (request != null && dispatcher != null) {
                    response = dispatcher.invoke(request);
                    eic.setResponseMessageContext(response);
                    break block8;
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invokeErr"));
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            finally {
                request.getMessage().setPostPivot();
            }
        }
        this.handleResponse(eic);
        return eic;
    }

    public void invokeAsync(EndpointInvocationContext eic) {
        block8: {
            boolean good;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invocation pattern: asynchronous");
            }
            if (!(good = this.handleRequest(eic))) {
                return;
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            try {
                EndpointDispatcher dispatcher = eic.getDispatcher();
                if (request != null && dispatcher != null) {
                    dispatcher.invokeAsync(request, eic.getCallback());
                    break block8;
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invokeErr"));
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            finally {
                request.getMessage().setPostPivot();
            }
        }
    }

    public void invokeOneWay(EndpointInvocationContext eic) {
        block8: {
            boolean good;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invocation pattern: one-way");
            }
            if (!(good = this.handleRequest(eic))) {
                return;
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            try {
                EndpointDispatcher dispatcher = eic.getDispatcher();
                if (request != null && dispatcher != null) {
                    dispatcher.invokeOneWay(request);
                    break block8;
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invokeErr"));
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            finally {
                request.getMessage().setPostPivot();
            }
        }
    }

    protected boolean handleRequest(EndpointInvocationContext eic) {
        org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
        Class serviceEndpoint = this.getServiceImplementation(request);
        EndpointDescription endpointDesc = this.getEndpointDescription(request, serviceEndpoint);
        request.setEndpointDescription(endpointDesc);
        if (eic.getHandlers() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No handlers found on the InvocationContext, initializing handler list.");
            }
            eic.setHandlers(new HandlerResolverImpl(endpointDesc.getServiceDescription()).getHandlerChain(endpointDesc.getPortInfo()));
        }
        org.apache.axis2.jaxws.core.MessageContext responseMsgContext = null;
        try {
            ServiceInstanceFactory instanceFactory = (ServiceInstanceFactory)FactoryRegistry.getFactory(ServiceInstanceFactory.class);
            Object serviceInstance = instanceFactory.createServiceInstance(request, serviceEndpoint);
            this.saveRequestMessage(request);
            boolean success = HandlerInvokerUtils.invokeInboundHandlers(request.getMEPContext(), eic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, EndpointController.isOneWay(request.getAxisMessageContext()));
            if (success) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JAX-WS inbound handler chain invocation complete.");
                }
                EndpointDispatcher dispatcher = this.getEndpointDispatcher(request, serviceEndpoint, serviceInstance);
                eic.setEndpointDispatcher(dispatcher);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"JAX-WS inbound handler chain invocation completed with errors.");
            }
            responseMsgContext = MessageContextUtils.createResponseMessageContext(request);
            responseMsgContext.setMessage(request.getMessage());
            eic.setResponseMessageContext(responseMsgContext);
            return false;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    protected boolean handleResponse(EndpointInvocationContext eic) {
        org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
        org.apache.axis2.jaxws.core.MessageContext response = eic.getResponseMessageContext();
        try {
            if (response != null && !EndpointController.isOneWay(eic.getRequestMessageContext().getAxisMessageContext())) {
                response.setMEPContext(request.getMEPContext());
                HandlerInvokerUtils.invokeOutboundHandlers(response.getMEPContext(), eic.getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        finally {
            this.restoreRequestMessage(request);
        }
        eic.setResponseMessageContext(response);
        return true;
    }

    private Class getServiceImplementation(org.apache.axis2.jaxws.core.MessageContext mc) {
        String implClassName = this.getServiceImplClassName(mc);
        Class implClass = this.loadServiceImplClass(implClassName, mc.getClassLoader());
        return implClass;
    }

    protected EndpointDispatcher getEndpointDispatcher(Class serviceImplClass, Object serviceInstance) throws Exception {
        return this.getEndpointDispatcher(null, serviceImplClass, serviceInstance);
    }

    protected EndpointDispatcher getEndpointDispatcher(org.apache.axis2.jaxws.core.MessageContext mc, Class serviceImplClass, Object serviceInstance) throws Exception {
        EndpointDispatcherFactory factory = (EndpointDispatcherFactory)FactoryRegistry.getFactory(EndpointDispatcherFactory.class);
        return factory.createEndpointDispatcher(mc, serviceImplClass, serviceInstance);
    }

    private String getServiceImplClassName(org.apache.axis2.jaxws.core.MessageContext mc) {
        MessageContext axisMsgContext = mc.getAxisMessageContext();
        AxisService as = axisMsgContext.getAxisService();
        Parameter param = as.getParameter("ServiceClass");
        if (param == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr2"));
        }
        String className = ((String)param.getValue()).trim();
        return className;
    }

    private Class loadServiceImplClass(String className, ClassLoader cl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to load service impl class: " + className));
        }
        try {
            Class _class = EndpointController.forName(className, true, cl);
            return _class;
        }
        catch (Throwable cnf) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr4", (String)className), (Throwable)cnf);
        }
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PrivilegedActionException thrown from AccessController: " + e));
                log.debug((Object)("Real Cause is " + e.getException().getCause()));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private EndpointDescription getEndpointDescription(org.apache.axis2.jaxws.core.MessageContext mc, Class implClass) {
        AxisService axisSvc = mc.getAxisMessageContext().getAxisService();
        if (axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription") != null) {
            Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            return ed;
        }
        ServiceDescription sd = DescriptionFactory.createServiceDescriptionFromServiceImpl((Class)implClass, (AxisService)axisSvc);
        EndpointDescription ed = (EndpointDescription)sd.getEndpointDescriptions_AsCollection().iterator().next();
        return ed;
    }

    private EndpointLifecycleManager createEndpointlifecycleManager() {
        EndpointLifecycleManagerFactory elmf = (EndpointLifecycleManagerFactory)FactoryRegistry.getFactory(EndpointLifecycleManagerFactory.class);
        return elmf.createEndpointLifecycleManager();
    }

    private void saveRequestMessage(org.apache.axis2.jaxws.core.MessageContext requestMsgContext) {
        Boolean value = (Boolean)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG");
        if (value != null && value == Boolean.TRUE) {
            Message m = requestMsgContext.getMessage();
            String savedMsg = m.getAsOMElement().toString();
            requestMsgContext.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.spi.SAVED_REQUEST_MSG_TEXT", (Object)savedMsg);
        }
    }

    private void restoreRequestMessage(org.apache.axis2.jaxws.core.MessageContext requestMsgContext) {
        String savedMsg;
        Boolean value = (Boolean)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG");
        if (value != null && value == Boolean.TRUE && (savedMsg = (String)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVED_REQUEST_MSG_TEXT")) != null && savedMsg.length() > 0) {
            try {
                StringReader sr = new StringReader(savedMsg);
                XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((Reader)sr);
                MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                Protocol protocol = requestMsgContext.getAxisMessageContext().isDoingREST() ? Protocol.rest : null;
                Message msg = mf.createFrom(xmlreader, protocol);
                requestMsgContext.setMessage(msg);
            }
            catch (Throwable e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
    }

    public static boolean isOneWay(MessageContext mc) {
        AxisOperation op;
        String mep;
        return mc != null && ((mep = (op = mc.getAxisOperation()).getMessageExchangePattern()).equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only"));
    }
}

