/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.ArtifactProcessor;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBuilder {
    private static Log log = LogFactory.getLog(AnnotationBuilder.class);
    private static final Class[] noClass = new Class[0];

    private AnnotationBuilder() {
    }

    public static Map<String, AnnotationDesc> getAnnotationDescs(ServiceDescription serviceDesc, ArtifactProcessor ap) {
        HashMap<String, AnnotationDesc> map = new HashMap<String, AnnotationDesc>();
        EndpointDescription[] endpointDescs = serviceDesc.getEndpointDescriptions();
        if (endpointDescs != null) {
            for (int i = 0; i < endpointDescs.length; ++i) {
                AnnotationBuilder.getAnnotationDescs(endpointDescs[i], ap, map);
            }
        }
        return map;
    }

    private static void getAnnotationDescs(EndpointDescription endpointDesc, ArtifactProcessor ap, Map<String, AnnotationDesc> map) {
        EndpointInterfaceDescription endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription();
        if (endpointInterfaceDesc != null) {
            AnnotationBuilder.getAnnotationDescs(endpointInterfaceDesc, ap, map);
        }
    }

    private static void getAnnotationDescs(EndpointInterfaceDescription endpointInterfaceDesc, ArtifactProcessor ap, Map<String, AnnotationDesc> map) {
        OperationDescription[] opDescs = endpointInterfaceDesc.getOperations();
        if (opDescs != null) {
            for (int i = 0; i < opDescs.length; ++i) {
                AnnotationBuilder.getAnnotationDescs(opDescs[i], ap, map);
            }
        }
    }

    private static void getAnnotationDescs(OperationDescription opDesc, ArtifactProcessor ap, Map<String, AnnotationDesc> map) {
        Class cls;
        String wrapperName;
        FaultDescription[] faultDescs;
        ParameterDescription[] parameterDescs = opDesc.getParameterDescriptions();
        if (parameterDescs != null) {
            for (int i = 0; i < parameterDescs.length; ++i) {
                AnnotationBuilder.getAnnotationDescs(parameterDescs[i], map);
            }
        }
        if ((faultDescs = opDesc.getFaultDescriptions()) != null) {
            for (int i = 0; i < faultDescs.length; ++i) {
                AnnotationBuilder.getAnnotationDescs(faultDescs[i], ap, map);
            }
        }
        if ((wrapperName = ap.getRequestWrapperMap().get(opDesc)) != null) {
            AnnotationBuilder.addAnnotation(wrapperName, map);
        }
        if ((wrapperName = ap.getResponseWrapperMap().get(opDesc)) != null) {
            AnnotationBuilder.addAnnotation(wrapperName, map);
        }
        if ((cls = opDesc.getResultActualType()) != null && cls != Void.TYPE && cls != Void.class) {
            AnnotationBuilder.addAnnotation(cls, map);
        }
    }

    private static void getAnnotationDescs(ParameterDescription paramDesc, Map<String, AnnotationDesc> map) {
        Class paramClass = paramDesc.getParameterActualType();
        if (paramClass != null) {
            AnnotationBuilder.getTypeAnnotationDescs(paramClass, map);
        }
    }

    private static void getAnnotationDescs(FaultDescription faultDesc, ArtifactProcessor ap, Map<String, AnnotationDesc> map) {
        FaultBeanDesc faultBeanDesc = ap.getFaultBeanDescMap().get(faultDesc);
        Class faultBean = AnnotationBuilder.loadClass(faultBeanDesc.getFaultBeanClassName());
        if (faultBean != null) {
            AnnotationBuilder.getTypeAnnotationDescs(faultBean, map);
        }
    }

    private static void getTypeAnnotationDescs(Class cls, Map<String, AnnotationDesc> map) {
        if (JAXBElement.class.isAssignableFrom(cls)) {
            try {
                Method m = cls.getMethod("getValue", noClass);
                Class<?> cls2 = m.getReturnType();
                AnnotationBuilder.addAnnotation(cls2, map);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot find JAXBElement.getValue method.");
                }
            }
        } else {
            AnnotationBuilder.addAnnotation(cls, map);
        }
    }

    private static void addAnnotation(String className, Map<String, AnnotationDesc> map) {
        Class clz;
        if (map.get(className) == null && (clz = AnnotationBuilder.loadClass(className)) != null) {
            AnnotationBuilder.addAnnotation(clz, map);
        }
    }

    private static void addAnnotation(Class cls, Map<String, AnnotationDesc> map) {
        String className = cls.getCanonicalName();
        if (map.get(className) == null) {
            AnnotationDesc desc = AnnotationDescImpl.create(cls);
            map.put(className, desc);
            if (cls.isPrimitive()) {
                Class class2 = ClassUtils.getWrapperClass(cls);
                AnnotationDesc desc2 = AnnotationDescImpl.create(class2);
                map.put(class2.getCanonicalName(), desc2);
            } else {
                Class class2 = ClassUtils.getPrimitiveClass(cls);
                if (class2 != null) {
                    AnnotationDesc desc2 = AnnotationDescImpl.create(class2);
                    map.put(class2.getCanonicalName(), desc2);
                }
            }
        }
    }

    private static Class loadClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            return AnnotationBuilder.forName(className, true, AnnotationBuilder.getContextClassLoader());
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PackageSetBuilder cannot load the following class:" + className));
            }
            return null;
        }
    }

    static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }
}

