/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManager;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.handler.BaseHandlerResolver;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
extends BaseHandlerResolver {
    private static Log log = LogFactory.getLog(HandlerResolverImpl.class);
    private ServiceDescription serviceDesc;

    public HandlerResolverImpl(ServiceDescription sd) {
        this.serviceDesc = sd;
    }

    public List<Handler> getHandlerChain(PortInfo portinfo) {
        return this.resolveHandlers(portinfo);
    }

    private ArrayList<Handler> resolveHandlers(PortInfo portinfo) throws WebServiceException {
        Iterator it;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        this.handlerChainsType = this.serviceDesc.getHandlerChain();
        EndpointDescription ed = null;
        if (portinfo != null) {
            ed = this.serviceDesc.getEndpointDescription(portinfo.getPortName());
        }
        if (ed != null) {
            HandlerChainsType handlerCT_fromEndpointDesc = ed.getHandlerChain();
            if (this.handlerChainsType == null) {
                this.handlerChainsType = handlerCT_fromEndpointDesc;
            }
        }
        Iterator iterator = it = this.handlerChainsType == null ? null : this.handlerChainsType.getHandlerChain().iterator();
        while (it != null && it.hasNext()) {
            HandlerChainType handlerChainType = (HandlerChainType)it.next();
            if (!HandlerResolverImpl.chainResolvesToPort(handlerChainType, portinfo)) continue;
            List handlerTypeList = handlerChainType.getHandler();
            for (HandlerType handlerType : handlerTypeList) {
                Handler handler;
                String portHandler = handlerType.getHandlerClass().getValue();
                MessageContext ctx = new MessageContext();
                ctx.setEndpointDescription(ed);
                HandlerLifecycleManager hlm = this.createHandlerlifecycleManager();
                try {
                    handler = hlm.createHandlerInstance(ctx, HandlerResolverImpl.loadClass(portHandler));
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)("Successfully instantiated the class: " + handler.getClass()));
                }
                if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((Handler)((LogicalHandler)handler));
                    continue;
                }
                if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((Handler)((SOAPHandler)handler));
                    continue;
                }
                if (Handler.class.isAssignableFrom(handler.getClass())) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr1", (String)handler.getClass().getName()));
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr2", (String)handler.getClass().getName()));
            }
        }
        return handlers;
    }

    private HandlerLifecycleManager createHandlerlifecycleManager() {
        HandlerLifecycleManagerFactory elmf = (HandlerLifecycleManagerFactory)FactoryRegistry.getFactory(HandlerLifecycleManagerFactory.class);
        return elmf.createHandlerLifecycleManager();
    }
}

