/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Response;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.axis2.jaxws.BindingProvider;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.proxy.ProxyAsyncListener;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.AxisInvocationController;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.factory.MethodMarshallerFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSProxyHandler
extends BindingProvider
implements InvocationHandler {
    private static Log log = LogFactory.getLog(JAXWSProxyHandler.class);
    protected ServiceDescription serviceDesc = null;
    private Class seiClazz = null;
    private Method method = null;

    public JAXWSProxyHandler(ServiceDelegate delegate, Class seiClazz, EndpointDescription epDesc) {
        super(delegate, epDesc);
        this.seiClazz = seiClazz;
        this.serviceDesc = delegate.getServiceDescription();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Attemping to invoke Method: " + method.getName()));
        }
        this.method = method;
        if (!this.isValidMethodCall(method)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"proxyErr1", (String)method.getName(), (String)this.seiClazz.getName()));
        }
        if (!this.isPublic(method)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"proxyPrivateMethod", (String)method.getName()));
        }
        if (this.isBindingProviderInvoked(method)) {
            if (debug) {
                log.debug((Object)"Invoking a public method on the javax.xml.ws.BindingProvider interface.");
            }
            try {
                return method.invoke((Object)this, args);
            }
            catch (Throwable e) {
                if (debug) {
                    log.debug((Object)("An error occured while invoking the method: " + e.getMessage()));
                }
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        OperationDescription operationDesc = this.endpointDesc.getEndpointInterfaceDescription().getOperation(method);
        if (this.isMethodExcluded(operationDesc)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"proxyExcludedMethod", (String)method.getName()));
        }
        return this.invokeSEIMethod(method, args);
    }

    private Object invokeSEIMethod(Method method, Object[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to invoke SEI Method " + method.getName()));
        }
        OperationDescription operationDesc = this.endpointDesc.getEndpointInterfaceDescription().getOperation(method);
        InvocationContext requestIC = InvocationContextFactory.createInvocationContext(null);
        MessageContext request = this.createRequest(method, args);
        request.setEndpointDescription(this.getEndpointDescription());
        request.setOperationDescription(operationDesc);
        Binding bnd = this.getBinding();
        if (bnd != null && bnd instanceof SOAPBinding && ((SOAPBinding)bnd).isMTOMEnabled()) {
            Message requestMsg = request.getMessage();
            requestMsg.setMTOMEnabled(true);
        }
        requestIC.setHandlers(bnd.getHandlerChain());
        requestIC.setRequestMessageContext(request);
        requestIC.setServiceClient(this.serviceDelegate.getServiceClient(this.endpointDesc.getPortQName()));
        AxisInvocationController controller = new AxisInvocationController();
        ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), request);
        if (operationDesc.isOneWay()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OneWay Call");
            }
            controller.invokeOneWay(requestIC);
            this.checkMaintainSessionState(request, requestIC);
        }
        if (method.getReturnType() == Future.class) {
            ExecutorService es;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Async Callback");
            }
            AsyncHandler asyncHandler = null;
            for (Object obj : args) {
                if (obj == null || !AsyncHandler.class.isAssignableFrom(obj.getClass())) continue;
                asyncHandler = (AsyncHandler)obj;
                break;
            }
            if (asyncHandler == null) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"proxyNullCallback"));
            }
            AsyncResponse listener = this.createProxyListener(args, operationDesc);
            requestIC.setAsyncResponseListener(listener);
            if (this.serviceDelegate.getExecutor() != null && this.serviceDelegate.getExecutor() instanceof ExecutorService && (es = (ExecutorService)this.serviceDelegate.getExecutor()).isShutdown()) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ExecutorShutdown"));
            }
            requestIC.setExecutor(this.serviceDelegate.getExecutor());
            Future<?> future = controller.invokeAsync(requestIC, asyncHandler);
            this.checkMaintainSessionState(request, requestIC);
            return future;
        }
        if (method.getReturnType() == Response.class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Async Polling");
            }
            AsyncResponse listener = this.createProxyListener(args, operationDesc);
            requestIC.setAsyncResponseListener(listener);
            requestIC.setExecutor(this.serviceDelegate.getExecutor());
            Response response = controller.invokeAsync(requestIC);
            this.checkMaintainSessionState(request, requestIC);
            return response;
        }
        if (!operationDesc.isOneWay()) {
            InvocationContext responseIC = controller.invoke(requestIC);
            this.checkMaintainSessionState(request, requestIC);
            MessageContext responseContext = responseIC.getResponseMessageContext();
            ApplicationContextMigratorUtil.performMigrationFromMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getResponseContext(), responseContext);
            Object responseObj = this.createResponse(method, args, responseContext, operationDesc);
            return responseObj;
        }
        return null;
    }

    private AsyncResponse createProxyListener(Object[] args, OperationDescription operationDesc) {
        ProxyAsyncListener listener = new ProxyAsyncListener(operationDesc);
        listener.setHandler(this);
        listener.setInputArgs(args);
        return listener;
    }

    protected boolean isAsync() {
        String methodName = this.method.getName();
        Class<Object> returnType = this.method.getReturnType();
        return methodName.endsWith("Async") && (returnType.isAssignableFrom(Response.class) || returnType.isAssignableFrom(Future.class));
    }

    protected MessageContext createRequest(Method method, Object[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a new Message using the request parameters.");
        }
        OperationDescription operationDesc = this.endpointDesc.getEndpointInterfaceDescription().getOperation(method);
        Message message = MethodMarshallerFactory.getMarshaller(operationDesc, true, null).marshalRequest(args, operationDesc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request Message created successfully.");
        }
        MessageContext request = new MessageContext();
        request.setMessage(message);
        request.setProperties(this.getRequestContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request MessageContext created successfully.");
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createResponse(Method method, Object[] args, MessageContext responseContext, OperationDescription operationDesc) throws Throwable {
        Message responseMsg = responseContext.getMessage();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing the response Message to create the return value(s).");
            }
            if (JAXWSProxyHandler.hasFaultResponse(responseContext)) {
                Throwable t = JAXWSProxyHandler.getFaultResponse(responseContext, operationDesc);
                throw t;
            }
            ClassLoader cl = (ClassLoader)responseContext.getProperty("CACHE_CLASSLOADER");
            Object object = MethodMarshallerFactory.getMarshaller(operationDesc, true, cl).demarshalResponse(responseMsg, args, operationDesc);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The response was processed and the return value created successfully.");
            }
            Object object2 = object;
            return object2;
        }
        finally {
            responseMsg.close();
        }
    }

    protected static Throwable getFaultResponse(MessageContext msgCtx, OperationDescription opDesc) {
        Message msg = msgCtx.getMessage();
        if (opDesc.isJAXWSAsyncClientMethod()) {
            opDesc = opDesc.getSyncOperation();
        }
        if (msg != null && msg.isFault()) {
            ClassLoader cl = (ClassLoader)msgCtx.getProperty("CACHE_CLASSLOADER");
            Throwable object = MethodMarshallerFactory.getMarshaller(opDesc, true, cl).demarshalFaultResponse(msg, opDesc);
            if (log.isDebugEnabled() && object != null) {
                log.debug((Object)"A fault was found and processed.");
                log.debug((Object)("Throwing a fault of type: " + object.getClass().getName() + " back to the clent."));
            }
            return object;
        }
        if (msgCtx.getLocalException() != null) {
            return ExceptionFactory.makeWebServiceException((Throwable)msgCtx.getLocalException());
        }
        return null;
    }

    protected static boolean hasFaultResponse(MessageContext mc) {
        if (mc.getMessage() != null && mc.getMessage().isFault()) {
            return true;
        }
        return mc.getLocalException() != null;
    }

    private boolean isBindingProviderInvoked(Method method) {
        Class<?> methodsClass = method.getDeclaringClass();
        return this.seiClazz != methodsClass;
    }

    private boolean isValidMethodCall(Method method) {
        Class<javax.xml.ws.BindingProvider> clazz = method.getDeclaringClass();
        return clazz.isAssignableFrom(this.seiClazz) || clazz.isAssignableFrom(org.apache.axis2.jaxws.spi.BindingProvider.class) || clazz.isAssignableFrom(javax.xml.ws.BindingProvider.class);
    }

    private boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private boolean isMethodExcluded(OperationDescription operationDesc) {
        return operationDesc.isExcluded();
    }

    public Class getSeiClazz() {
        return this.seiClazz;
    }

    public void setSeiClazz(Class seiClazz) {
        this.seiClazz = seiClazz;
    }
}

