/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axiom.om.util.StAXUtils;

public class MTOMXMLStreamWriter
implements XMLStreamWriter {
    private XMLStreamWriter xmlWriter;
    private OutputStream outStream;
    private LinkedList binaryNodeList = new LinkedList();
    private ByteArrayOutputStream bufferedXML;
    private OMOutputFormat format = new OMOutputFormat();
    private boolean isEndDocument = false;
    private boolean isComplete = false;
    private int depth = 0;

    public MTOMXMLStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public MTOMXMLStreamWriter(OutputStream outStream, OMOutputFormat format) throws XMLStreamException, FactoryConfigurationError {
        this.format = format;
        this.outStream = outStream;
        if (format.getCharSetEncoding() == null) {
            format.setCharSetEncoding("utf-8");
        }
        if (format.isOptimized()) {
            this.bufferedXML = new ByteArrayOutputStream();
            this.xmlWriter = StAXUtils.createXMLStreamWriter(this.bufferedXML, format.getCharSetEncoding());
        } else {
            this.xmlWriter = StAXUtils.createXMLStreamWriter(outStream, format.getCharSetEncoding());
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string);
        ++this.depth;
    }

    public void writeStartElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1);
        ++this.depth;
    }

    public void writeStartElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1, string2);
        ++this.depth;
    }

    public void writeEmptyElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1);
    }

    public void writeEmptyElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1, string2);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string);
    }

    public void writeEndElement() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
        --this.depth;
    }

    public void writeEndDocument() throws XMLStreamException {
        this.xmlWriter.writeEndDocument();
        this.isEndDocument = true;
    }

    public void close() throws XMLStreamException {
        this.xmlWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.xmlWriter.flush();
        if (this.format.isOptimized() && !this.isComplete & (this.isEndDocument || this.depth == 0)) {
            this.isComplete = true;
            String SOAPContentType = this.format.isSOAP11() ? "text/xml" : "application/soap+xml";
            try {
                String bufferedXMLText = new String(this.bufferedXML.toByteArray(), this.format.getCharSetEncoding());
                MIMEOutputUtils.complete(this.outStream, bufferedXMLText, this.binaryNodeList, this.format.getMimeBoundary(), this.format.getRootContentId(), this.format.getCharSetEncoding(), SOAPContentType);
                this.bufferedXML.close();
                this.bufferedXML = null;
            }
            catch (UnsupportedEncodingException e) {
                throw new OMException(e);
            }
            catch (IOException e) {
                throw new OMException(e);
            }
        }
    }

    public void writeAttribute(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1);
    }

    public void writeAttribute(String string, String string1, String string2, String string3) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2, string3);
    }

    public void writeAttribute(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2);
    }

    public void writeNamespace(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeNamespace(string, string1);
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(string);
    }

    public void writeComment(String string) throws XMLStreamException {
        this.xmlWriter.writeComment(string);
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string);
    }

    public void writeProcessingInstruction(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string, string1);
    }

    public void writeCData(String string) throws XMLStreamException {
        this.xmlWriter.writeCData(string);
    }

    public void writeDTD(String string) throws XMLStreamException {
        this.xmlWriter.writeDTD(string);
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.xmlWriter.writeEntityRef(string);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string);
    }

    public void writeStartDocument(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string, string1);
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.xmlWriter.writeCharacters(string);
    }

    public void writeCharacters(char[] chars, int i, int i1) throws XMLStreamException {
        this.xmlWriter.writeCharacters(chars, i, i1);
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.xmlWriter.getPrefix(string);
    }

    public void setPrefix(String string, String string1) throws XMLStreamException {
        this.xmlWriter.setPrefix(string, string1);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.setDefaultNamespace(string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.xmlWriter.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.xmlWriter.getNamespaceContext();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.xmlWriter.getProperty(string);
    }

    public boolean isOptimized() {
        return this.format.isOptimized();
    }

    public String getContentType() {
        return this.format.getContentType();
    }

    public void writeOptimized(OMText node) {
        this.binaryNodeList.add(node);
    }

    public void setXmlStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public XMLStreamWriter getXmlStreamWriter() {
        return this.xmlWriter;
    }

    public String getMimeBoundary() {
        return this.format.getMimeBoundary();
    }

    public String getRootContentId() {
        return this.format.getRootContentId();
    }

    public String getNextContentId() {
        return this.format.getNextContentId();
    }

    public String getCharSetEncoding() {
        return this.format.getCharSetEncoding();
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.format.setCharSetEncoding(charSetEncoding);
    }

    public String getXmlVersion() {
        return this.format.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) {
        this.format.setXmlVersion(xmlVersion);
    }

    public void setSoap11(boolean b) {
        this.format.setSOAP11(b);
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.format.isIgnoreXMLDeclaration();
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.format.setIgnoreXMLDeclaration(ignoreXMLDeclaration);
    }

    public void setDoOptimize(boolean b) {
        this.format.setDoOptimize(b);
    }

    public void setOutputFormat(OMOutputFormat format) {
        this.format = format;
    }

    public OutputStream getOutputStream() throws XMLStreamException {
        OutputStream os = null;
        os = this.bufferedXML != null ? this.bufferedXML : this.outStream;
        if (os != null) {
            this.writeCharacters("");
            this.flush();
        }
        return os;
    }
}

