/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.attachments.impl.AbstractPart;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.om.util.UUIDGenerator;

public class PartOnFile
extends AbstractPart {
    File backingFile;

    PartOnFile(Hashtable headers, InputStream is1, InputStream is2, String attachmentDir) throws IOException {
        super(headers);
        this.backingFile = PartOnFile.createFile(attachmentDir);
        FileOutputStream fos = new FileOutputStream(this.backingFile);
        BufferUtils.inputStream2OutputStream(is1, fos);
        BufferUtils.inputStream2OutputStream(is2, fos);
        fos.flush();
        fos.close();
    }

    private static File createFile(String attachmentDir) throws IOException {
        File file = null;
        File dir = null;
        if (attachmentDir != null && !(dir = new File(attachmentDir)).exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Given Axis2 Attachment File Cache Location " + dir + "  should be a directory.");
        }
        String id = UUIDGenerator.getUUID();
        id = id.replaceAll(":", "_");
        String fileString = "Axis2" + id + ".att";
        file = new File(dir, fileString);
        return file;
    }

    public DataHandler getDataHandler() throws MessagingException {
        CachedFileDataSource dataSource = new CachedFileDataSource(this.backingFile);
        dataSource.setContentType(this.getContentType());
        return new DataHandler((DataSource)dataSource);
    }

    public String getFileName() throws MessagingException {
        return this.backingFile.getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return new FileInputStream(this.backingFile);
    }

    public int getSize() {
        return (int)this.backingFile.length();
    }
}

