/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.mail.Header;
import org.apache.axiom.attachments.MIMEBodyPartInputStream;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.impl.PartOnFile;
import org.apache.axiom.attachments.impl.PartOnMemory;
import org.apache.axiom.om.OMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$attachments$impl$PartFactory == null ? (class$org$apache$axiom$attachments$impl$PartFactory = PartFactory.class$("org.apache.axiom.attachments.impl.PartFactory")) : class$org$apache$axiom$attachments$impl$PartFactory));
    static /* synthetic */ Class class$org$apache$axiom$attachments$impl$PartFactory;

    public static Part createPart(MIMEBodyPartInputStream in, boolean isSOAPPart, int threshholdSize, String attachmentDir, int messageContentLength) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start createPart()");
            log.debug((Object)("  isSOAPPart=" + isSOAPPart));
            log.debug((Object)("  threshholdSize= " + threshholdSize));
            log.debug((Object)("  attachmentDir=" + attachmentDir));
            log.debug((Object)("  messageContentLength " + messageContentLength));
        }
        try {
            Hashtable headers = new Hashtable();
            PartFactory.readHeaders(in, headers);
            if (isSOAPPart || threshholdSize <= 0 || messageContentLength > 0 && messageContentLength < threshholdSize) {
                BAOS baos = new BAOS();
                BufferUtils.inputStream2OutputStream(in, baos);
                return new PartOnMemory(headers, baos.toByteArray(), baos.size());
            }
            BAOS baos = new BAOS();
            int total = BufferUtils.inputStream2OutputStream(in, baos, threshholdSize);
            if (total < threshholdSize) {
                return new PartOnMemory(headers, baos.toByteArray(), baos.size());
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray(), 0, baos.size());
            return new PartOnFile(headers, bais, in, attachmentDir);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    private static void readHeaders(InputStream in, Map headers) throws IOException {
        int ch;
        if (log.isDebugEnabled()) {
            log.debug((Object)"initHeaders");
        }
        boolean done = false;
        StringBuffer sb = new StringBuffer(50);
        while (!done && (ch = in.read()) != -1) {
            if (ch == 13) {
                ch = in.read();
                if (ch == 10) {
                    ch = in.read();
                    if (ch == 13) {
                        ch = in.read();
                        if (ch != 10) continue;
                        PartFactory.readHeader(sb, headers);
                        sb.delete(0, sb.length());
                        done = true;
                        continue;
                    }
                    PartFactory.readHeader(sb, headers);
                    sb.delete(0, sb.length());
                    sb.append((char)ch);
                    continue;
                }
                sb.append(13);
                sb.append((char)ch);
                continue;
            }
            sb.append((char)ch);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End initHeaders");
        }
    }

    private static void readHeader(StringBuffer header, Map headers) {
        int delimiter = header.indexOf(":");
        String name = header.substring(0, delimiter).trim();
        String value = header.substring(delimiter + 1, header.length()).trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("addHeader: (" + name + ") value=(" + value + ")"));
        }
        Header headerObj = new Header(name, value);
        String key = name.toLowerCase();
        headers.put(key, headerObj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BAOS
    extends ByteArrayOutputStream {
        public BAOS() {
            super(16384);
        }

        public byte[] toByteArray() {
            return this.buf;
        }
    }
}

