/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BufferUtils {
    public static final int BUFFER_LEN = 16384;

    public static void inputStream2OutputStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[16384];
        int bytesRead = is.read(buffer);
        while (bytesRead > 0 || is.available() > 0) {
            os.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer);
        }
    }

    public static int inputStream2OutputStream(InputStream is, OutputStream os, int limit) throws IOException {
        byte[] buffer = new byte[16384];
        int totalWritten = 0;
        int bytesRead = 0;
        do {
            int len;
            if ((bytesRead = is.read(buffer, 0, len = limit - totalWritten > 16384 ? 16384 : limit - totalWritten)) <= 0) continue;
            os.write(buffer, 0, bytesRead);
            if (bytesRead <= 0) continue;
            totalWritten += bytesRead;
        } while (totalWritten < limit && (bytesRead > 0 || is.available() > 0));
        return totalWritten;
    }
}

