/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.validator;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.wso2.validator.Util;

public class Service {
    public static final String SERVICES_XSL_LOCATION = "org/wso2/validator/service-validator.xsl";
    public static final String SERVICES_XSL_FORMATTER_LOCATION = "org/wso2/validator/service-formatter.xsl";

    public String validate(String fileId) throws AxisFault {
        String s;
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        String aarFileLocation = Util.getFilePathFromFileId(fileId, configCtx);
        if (aarFileLocation == null) {
            throw new AxisFault("Uploaded file is invalid and cannot continue the validation,");
        }
        try {
            InputStream in = Util.locateXML(aarFileLocation, ".aar", "META-INF/services.xml");
            Util.continueProcess(in);
            in = Util.locateXML(aarFileLocation, ".aar", "META-INF/services.xml");
            s = Util.doTransformation(in, aarFileLocation, SERVICES_XSL_LOCATION, SERVICES_XSL_FORMATTER_LOCATION, Service.class.getClassLoader());
            in.close();
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return s;
    }

    public String validateServicesXML(String fileId) throws AxisFault {
        String s;
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        try {
            String aarFileLocation = Util.getFilePathFromFileId(fileId, configCtx);
            if (aarFileLocation == null) {
                throw new AxisFault("Uploaded file is invalid and cannot continue the validation.");
            }
            FileInputStream in = new FileInputStream(aarFileLocation);
            Util.continueProcess(in);
            in = new FileInputStream(aarFileLocation);
            s = Util.doTransformation(in, aarFileLocation, SERVICES_XSL_LOCATION, SERVICES_XSL_FORMATTER_LOCATION, Service.class.getClassLoader());
            in.close();
        }
        catch (FileNotFoundException e) {
            String msg = "services.xml validation cannot be continued. This might cause due to uploading of invalid services.xml or internal server error. ";
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return s;
    }
}

