/*
 * Decompiled with CFR 0.152.
 */
package a1deployer;

import a1deployer.Axis1InOutMessageReceiver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.DOM2Writer;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.dataretrieval.WSDLSupplier;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.ParameterObserver;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Axis1Deployer
implements Deployer {
    protected static final Log log = LogFactory.getLog((Class)Axis1Deployer.class);
    ConfigurationContext configCtx;
    static final String REPLACEME = "http://ws.apache.org/axis";

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        log.info((Object)("Deploying - " + deploymentFileData.getName()));
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            File file = deploymentFileData.getFile();
            File parentFile = file.getParentFile();
            ClassLoader classLoader = Utils.getClassLoader((ClassLoader)this.configCtx.getAxisConfiguration().getSystemClassLoader(), (File)parentFile);
            Thread.currentThread().setContextClassLoader(classLoader);
            FileProvider config = new FileProvider(deploymentFileData.getAbsolutePath());
            AxisServer server = new AxisServer((EngineConfiguration)config);
            A1WSDLSupplier supplier = new A1WSDLSupplier(server);
            config.getDeployedServices();
            WSDDService[] services = config.getDeployment().getServices();
            AxisServiceGroup serviceGroup = new AxisServiceGroup();
            serviceGroup.addParameter("service.axis1.server", (Object)server);
            for (int i = 0; i < services.length; ++i) {
                AxisService axisService;
                String wsdlString;
                ServiceDesc service = services[i].getServiceDesc();
                log.info((Object)("Deploying Axis1 service -- " + service.getName()));
                MessageContext mc = new MessageContext((AxisEngine)server);
                try {
                    mc.setTargetService(service.getName());
                    mc.setProperty("transport.url", (Object)REPLACEME);
                    server.generateWSDL(mc);
                    Document wsdlDoc = (Document)mc.getProperty("WSDL");
                    wsdlString = DOM2Writer.nodeToString((Node)wsdlDoc, (boolean)true);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    continue;
                }
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(wsdlString.getBytes());
                    WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder((InputStream)bis);
                    axisService = builder.populateService();
                }
                catch (Exception e) {
                    String serviceName = service.getName();
                    if (REPLACEME.equals(service.getDefaultNamespace())) {
                        service.setDefaultNamespace(null);
                    }
                    log.info((Object)("Couldn't process WSDL for Axis1 service '" + serviceName + "', defaulting to passthrough mode."));
                    axisService = new AxisService(serviceName);
                    axisService.addParameter("supportSingleOperation", (Object)Boolean.TRUE);
                    axisService.addParameter("WSDLSupplier", (Object)supplier);
                    InOutAxisOperation op = new InOutAxisOperation(new QName("invokeAxis1Service"));
                    op.setDocumentation("This operation is a 'passthrough' for all operations in an RPC/encoded Axis1 service.");
                    axisService.addOperation((AxisOperation)op);
                }
                axisService.setName(service.getName());
                axisService.setClassLoader(classLoader);
                LockableHashtable params = services[i].getParametersTable();
                Enumeration paramKeys = params.keys();
                while (paramKeys.hasMoreElements()) {
                    String key = (String)paramKeys.nextElement();
                    axisService.addParameter(key, params.get(key));
                }
                Axis1InOutMessageReceiver receiver = new Axis1InOutMessageReceiver();
                AxisConfiguration axisConfig = this.configCtx.getAxisConfiguration();
                PhasesInfo phaseInfo = axisConfig.getPhasesInfo();
                Iterator ops = axisService.getOperations();
                while (ops.hasNext()) {
                    AxisOperation op = (AxisOperation)ops.next();
                    op.setMessageReceiver((MessageReceiver)receiver);
                    phaseInfo.setOperationPhases(op);
                }
                axisService.addParameter("serviceType", (Object)"axis1_service");
                axisService.setFileName(deploymentFileData.getFile().toURL());
                axisService.addParameterObserver((ParameterObserver)new Axis1ParameterObserver(service));
                serviceGroup.addService(axisService);
            }
            serviceGroup.setServiceGroupName(deploymentFileData.getName());
            this.configCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
        }
        catch (ConfigurationException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), sw.getBuffer().toString());
            throw new DeploymentException((Throwable)e);
        }
        catch (AxisFault e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException((Throwable)e);
        }
        finally {
            if (threadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) throws DeploymentException {
        log.info((Object)("Undeploying - " + fileName));
        AxisConfiguration axisConfig = this.configCtx.getAxisConfiguration();
        fileName = Utils.getShortFileName((String)fileName);
        AxisServiceGroup asg = axisConfig.getServiceGroup(fileName);
        try {
            if (asg != null) {
                axisConfig.removeServiceGroup(fileName);
                this.configCtx.removeServiceGroupContext(asg);
                log.info((Object)Messages.getMessage((String)"serviceremoved", (String)fileName));
            } else {
                axisConfig.removeFaultyService(fileName);
            }
        }
        catch (AxisFault axisFault) {
            axisConfig.removeFaultyService(fileName);
            throw new DeploymentException((Throwable)axisFault);
        }
    }

    public static class A1WSDLSupplier
    implements WSDLSupplier {
        AxisServer server;

        public A1WSDLSupplier(AxisServer server) {
            this.server = server;
        }

        public Definition getWSDL(AxisService service) throws AxisFault {
            Definition def = (Definition)service.getParameterValue("WSDLDefinition");
            if (def != null) {
                return def;
            }
            MessageContext mc = new MessageContext((AxisEngine)this.server);
            try {
                mc.setTargetService(service.getName());
                String addr = service.getEPRs()[0];
                mc.setProperty("transport.url", (Object)addr);
                this.server.generateWSDL(mc);
                Document wsdlDoc = (Document)mc.getProperty("WSDL");
                String wsdlString = DOM2Writer.nodeToString((Node)wsdlDoc, (boolean)true);
                ByteArrayInputStream bis = new ByteArrayInputStream(wsdlString.getBytes());
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                def = reader.readWSDL(null, new InputSource(bis));
                service.addParameter("WSDLDefinition", (Object)def);
                return def;
            }
            catch (Exception e) {
                log.error((Object)e);
                throw AxisFault.makeFault((Throwable)e);
            }
        }
    }

    public class Axis1ParameterObserver
    implements ParameterObserver {
        ServiceDesc serviceDesc;

        public Axis1ParameterObserver(ServiceDesc serviceDesc) {
            this.serviceDesc = serviceDesc;
        }

        public void parameterChanged(String name, Object value) {
            this.serviceDesc.setProperty(name, value);
        }
    }
}

