/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerException;
import org.wso2.utils.WSO2Utils;

public class ServerConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static Log log = LogFactory.getLog((Class)ServerConfigurator.class);
    private List globallyEngagedModules = new ArrayList();
    private String axis2xml;
    private String repoLocation;
    private String webLocation;
    private static ServerConfigurator instance;
    private boolean isInitialized;
    private boolean isUrlRepo;
    private boolean isUrlAxis2Xml;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public static ServerConfigurator getInstance() {
        if (instance == null) {
            instance = new ServerConfigurator();
        }
        return instance;
    }

    private ServerConfigurator() {
    }

    public void init(String repoLocation, String weblocation) throws ServerException {
        if (repoLocation == null) {
            throw new ServerException("Axis2 repository not specified!");
        }
        this.webLocation = weblocation;
        this.isUrlRepo = WSO2Utils.isURL(repoLocation);
        if (this.isUrlRepo) {
            try {
                new URL(repoLocation).openConnection().connect();
            }
            catch (IOException e) {
                throw new ServerException("Cannot connect to URL repository " + repoLocation, e);
            }
            this.repoLocation = repoLocation;
        } else {
            File repo = new File(repoLocation);
            if (repo.exists()) {
                this.repoLocation = repo.getAbsolutePath();
            } else {
                this.repoLocation = System.getProperty("wso2wsas.home") + File.separator + repoLocation;
                repo = new File(this.repoLocation);
                if (!repo.exists()) {
                    this.repoLocation = null;
                    throw new ServerException("Repository location '" + repoLocation + "' not found!");
                }
            }
        }
        this.axis2xml = WSO2Utils.getAxis2Xml();
        this.isUrlAxis2Xml = WSO2Utils.isURL(this.axis2xml);
        if (!this.isUrlAxis2Xml) {
            File configFile = new File(this.axis2xml);
            if (!configFile.exists()) {
                this.axis2xml = null;
                throw new ServerException("axis2.xml '" + this.axis2xml + "' not found!");
            }
        } else {
            try {
                URLConnection urlConnection = new URL(this.axis2xml).openConnection();
                urlConnection.connect();
            }
            catch (IOException e) {
                throw new ServerException("Cannot connect to axis2.xml URL " + repoLocation, e);
            }
            this.isInitialized = true;
        }
    }

    public synchronized AxisConfiguration getAxisConfiguration() throws AxisFault {
        this.axisConfig = null;
        try {
            InputStream axis2xmlStream;
            if (this.axis2xml != null && this.axis2xml.trim().length() != 0) {
                if (this.isUrlAxis2Xml) {
                    try {
                        axis2xmlStream = new URL(this.axis2xml).openStream();
                    }
                    catch (IOException e) {
                        throw new AxisFault("Cannot load axis2.xml from URL", (Throwable)e);
                    }
                } else {
                    axis2xmlStream = new FileInputStream(this.axis2xml);
                }
            } else {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                axis2xmlStream = cl.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
            }
            this.populateAxisConfiguration(axis2xmlStream);
        }
        catch (FileNotFoundException e) {
            throw new AxisFault("System cannot find the given axis2.xml " + this.axis2xml);
        }
        this.globallyEngagedModules = (List)this.axisConfig.getEngagedModules();
        if (this.repoLocation != null && this.repoLocation.trim().length() != 0) {
            try {
                if (this.isUrlRepo) {
                    URL axis2Repository = new URL(this.repoLocation);
                    this.axisConfig.setRepository(axis2Repository);
                    this.loadRepositoryFromURL(axis2Repository);
                }
                this.axisConfig.setRepository(new URL("file://" + this.repoLocation));
                this.loadRepository(this.repoLocation);
            }
            catch (MalformedURLException e) {
                throw new AxisFault("Invalid URL", (Throwable)e);
            }
        } else {
            this.loadFromClassPath();
        }
        Iterator iterator = this.globallyEngagedModules.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            log.info((Object)("Globally engaging module: " + name));
        }
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        return this.axisConfig;
    }

    public boolean isGlobalyEngaged(AxisModule axisModule) {
        String modName = axisModule.getName();
        Iterator iterator = this.globallyEngagedModules.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!modName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }

    public void loadServices() {
        ServerConfigurator.setWebLocationString((String)this.webLocation);
        if (this.repoLocation != null && this.repoLocation.trim().length() != 0) {
            if (this.isUrlRepo) {
                try {
                    this.loadServicesFromUrl(new URL(this.repoLocation));
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Services repository URL " + this.repoLocation + " is invalid"));
                }
            } else {
                super.loadServices();
            }
        }
    }
}

