/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ManagementFactory;
import org.wso2.utils.ServerConfiguration;

public class MBeanRegistrar {
    private static Log log = LogFactory.getLog((Class)MBeanRegistrar.class);

    public static void registerMBean(Object mbeanInstance, String objectName) throws Exception {
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        Set<ObjectName> set = mbs.queryNames(new ObjectName(objectName), null);
        if (!set.isEmpty()) {
            throw new Exception("MBean " + objectName + " already exists");
        }
        mbs.registerMBean(mbeanInstance, new ObjectName(objectName));
    }

    public static void registerMBean(Object mbeanInstance) {
        String jmxPort = ServerConfiguration.getInstance().getFirstProperty("Ports.JMX");
        String serverPackage = ServerConfiguration.getInstance().getFirstProperty("Package");
        if (serverPackage == null) {
            serverPackage = "wso2";
        }
        if (jmxPort != null) {
            try {
                String className = mbeanInstance.getClass().getName();
                if (className.indexOf(".") != -1) {
                    className = className.substring(className.lastIndexOf(".") + 1);
                }
                MBeanRegistrar.registerMBean(mbeanInstance, serverPackage + ":type=" + className);
            }
            catch (Exception e) {
                String msg = "Could not register " + mbeanInstance.getClass() + " MBean";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
    }
}

