/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils;

import java.io.File;
import java.io.IOException;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;

public class FileUtil {
    private static FileManipulator fileMan = new FileManipulator();

    public static boolean copyDirectory(File srcDir, File destDir) throws IOException {
        if (srcDir == null) {
            System.out.println("Creating directory \"" + destDir.getAbsolutePath() + "\"");
        } else {
            System.out.println("Copying \"" + srcDir.getAbsolutePath() + "\" to \"" + destDir.getAbsolutePath() + "\"");
        }
        boolean replaceDir = false;
        if (destDir.exists()) {
            String delete;
            do {
                System.out.print(destDir.getAbsolutePath() + " already exists. Do you want to replace this directory(y/n)? [y]: ");
            } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
            if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                fileMan.deleteDir(destDir);
                destDir.mkdirs();
                if (srcDir != null) {
                    try {
                        fileMan.copyDir(srcDir, destDir);
                    }
                    catch (IOException e) {
                        System.err.println(" Could not copy " + srcDir.getName() + " dir: " + e);
                        System.exit(1);
                    }
                }
                replaceDir = true;
            }
        } else {
            destDir.mkdirs();
            if (srcDir != null) {
                try {
                    fileMan.copyDir(srcDir, destDir);
                }
                catch (IOException e) {
                    System.err.println(" Could not copy " + srcDir.getName() + " dir: " + e);
                    System.exit(1);
                }
            }
            replaceDir = true;
        }
        System.out.println("OK");
        return replaceDir;
    }
}

