/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileManipulator {
    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void copyDir(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDir(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    public void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[10240];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        String[] items = libDir.list();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                if (fileNamePrefix != null && extension != null) {
                    if (!item.startsWith(fileNamePrefix) || !item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix == null && extension != null) {
                    if (!item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix != null && extension == null) {
                    if (!item.startsWith(fileNamePrefix)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                fileList.add(new File(libDirPath + File.separator + item));
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }
}

