/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.creation.core.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.wso2.wsf.ide.consumption.core.utils.DefaultCodegenUtil;
import org.wso2.wsf.ide.core.context.ServiceContext;
import org.wso2.wsf.ide.core.context.WSASEmitterContext;
import org.wso2.wsf.ide.core.plugin.WebServiceWSASCorePlugin;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FacetContainerUtils;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;
import org.wso2.wsf.ide.creation.core.data.DataModel;
import org.wso2.wsf.ide.creation.core.utils.CommonUtils;

public class WSASDefaultingCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private IWebService ws;
    private int scenario;
    IStatus status;

    public WSASDefaultingCommand(DataModel model, IWebService ws, int scenario) {
        this.model = model;
        this.ws = ws;
        this.scenario = scenario;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(WSASCoreUtils.tempRuntimeStatusFileLocation()));
            if (properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_STATUS)) {
                this.status = Status.OK_STATUS;
                this.model.setServerStatus(true);
            } else {
                this.status = StatusUtils.errorStatus((String)WSASCoreUIMessages.ERROR_SERVER_IS_NOT_SET);
            }
        }
        catch (FileNotFoundException e) {
            this.status = StatusUtils.errorStatus((String)(WSASCoreUIMessages.ERROR_INVALID_FILE_READ_WRITEL + WSASCoreUIMessages.ERROR_SERVER_IS_NOT_SET));
        }
        catch (IOException e) {
            this.status = StatusUtils.errorStatus((String)(WSASCoreUIMessages.ERROR_INVALID_FILE_READ_WRITEL + WSASCoreUIMessages.ERROR_SERVER_IS_NOT_SET));
        }
        ServiceContext serviceContext = ServiceContext.getInstance();
        if (this.scenario == 1) {
            this.model.setWsdlURI(this.ws.getWebServiceInfo().getWsdlURL());
            this.model.setDatabindingType(WSASCoreUIMessages.DATA_BINDING_ADB);
            DefaultCodegenUtil defaultCodegenUtil = new DefaultCodegenUtil(this.model);
            defaultCodegenUtil.populateModelParamsFromWSDL();
            this.model.setServicesXML(true);
            this.model.setServerXMLCheck(true);
            serviceContext.setServiceName(this.model.getServiceName());
        } else if (this.scenario == 0) {
            this.model.setServiceClass(this.ws.getWebServiceInfo().getImplURL());
            serviceContext.setServiceName(CommonUtils.classNameFromQualifiedName(this.ws.getWebServiceInfo().getImplURL()));
            this.model.setGenerateServicesXML(true);
        }
        serviceContext.addServiceToProjectMap(serviceContext.getServiceName(), this.model.getWebProjectName());
        String deployedWSDLURL = FacetContainerUtils.getDeployedWSDLURL((String)this.model.getWebProjectName(), (String)serviceContext.getServiceName());
        this.ws.getWebServiceInfo().setWsdlURL(deployedWSDLURL);
        WSASEmitterContext context = WebServiceWSASCorePlugin.getDefault().getWSASEmitterContext();
        System.setProperty("javax.net.ssl.trustStore", context.getWSASRuntimeLocation() + File.separator + "conf" + File.separator + "wso2wsas.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2wsas");
        System.setProperty("javax.net.ssl.trustStoreType", "wso2wsas");
        return this.status;
    }

    public DataModel getWebServiceDataModel() {
        return this.model;
    }
}

