/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.facet.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.wso2.wsf.ide.core.plugin.data.ServerModel;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;

public class WSASWebappUtils {
    private static String tempWarLocation = null;
    private static boolean alreadyWarExist = false;
    private static String previousProject;

    public static String copyWSASWar(IProgressMonitor monitor, String wsasHome, String project) throws FileNotFoundException, IOException {
        if (!alreadyWarExist || !project.equals(previousProject)) {
            previousProject = project;
            File tempWSASDirectory = new File(WSASCoreUtils.tempWSASDirectory());
            if (!tempWSASDirectory.exists()) {
                tempWSASDirectory.mkdirs();
            }
            if (tempWSASDirectory.isDirectory()) {
                tempWarLocation = WSASCoreUtils.addAnotherNodeToPath(WSASCoreUtils.tempWSASDirectory(), WSASCoreUIMessages.DIR_EXPLOADED_TEMPWAR);
                File tempWarLocationFile = new File(tempWarLocation);
                if (tempWarLocationFile.exists()) {
                    FileUtils.deleteDirectories(tempWarLocationFile);
                }
                tempWarLocationFile.mkdirs();
                Properties properties = new Properties();
                properties.load(new FileInputStream(WSASCoreUtils.tempWSASWebappFileLocation()));
                if (properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_PATH)) {
                    String wsasTempWebInfConf;
                    File wsasTempWebInfConfFile;
                    String wsasHomeLocation = ServerModel.getWsasServerPath() != null ? ServerModel.getWsasServerPath() : properties.getProperty(WSASCoreUIMessages.PROPERTY_KEY_PATH);
                    String wsasLibFile = WSASCoreUtils.addAnotherNodeToPath(wsasHomeLocation, "lib");
                    String wsasConfFile = WSASCoreUtils.addAnotherNodeToPath(wsasHomeLocation, "conf");
                    String wsasRepositoryFile = WSASCoreUtils.addAnotherNodeToPath(wsasHomeLocation, "repository");
                    String wsasTempWebInf = WSASCoreUtils.addAnotherNodeToPath(tempWarLocation, "WEB-INF");
                    String wsasTempWebInfLib = WSASCoreUtils.addAnotherNodeToPath(wsasTempWebInf, "lib");
                    File wsasTempWebInfLibFile = new File(wsasTempWebInfLib);
                    if (wsasTempWebInfLibFile.exists()) {
                        wsasTempWebInfLibFile.mkdirs();
                    }
                    if ((wsasTempWebInfConfFile = new File(wsasTempWebInfConf = WSASCoreUtils.addAnotherNodeToPath(wsasTempWebInf, "conf"))).exists()) {
                        wsasTempWebInfConfFile.mkdirs();
                    }
                    FileUtils.copyDirectory(new File(wsasLibFile), wsasTempWebInfLibFile);
                    FileUtils.deleteDirectories(FileUtils.addAnotherNodeToPath(wsasTempWebInfLib, "tomcat"));
                    FileUtils.copyDirectory(new File(wsasConfFile), wsasTempWebInfConfFile);
                    FileUtils.copyDirectory(new File(wsasRepositoryFile), new File(wsasTempWebInf));
                    FileUtils.filterOutRestrictedFiles(wsasTempWebInfLibFile.getAbsolutePath(), "servletapi", "jar");
                    alreadyWarExist = true;
                }
            } else {
                alreadyWarExist = false;
            }
        }
        return tempWarLocation;
    }
}

