/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.facet.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;

public class ContentCopyUtils {
    private static IWorkspaceRoot root_ = null;
    private static IWorkspace workspace_ = null;
    private List fileAndDirectoriesList = new ArrayList();
    FileInputStream finStream = null;

    public IStatus copyDirectoryRecursivelyIntoWorkspace(String sourceDir, String destinationDir, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        this.fileAndDirectoriesList.clear();
        File wsasWebappFolder = new File(sourceDir);
        this.visitAllDirsAndFiles(wsasWebappFolder);
        List deployFiles = new ArrayList();
        deployFiles = this.fileAndDirectoriesList;
        try {
            ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
            Path outputPath = new Path(destinationDir);
            IPath targetPath = null;
            boolean isDirectory = false;
            String tempOutputDir = wsasWebappFolder.toString();
            for (String deployFile : deployFiles) {
                File source = new File(deployFile);
                if (source.isDirectory()) {
                    isDirectory = true;
                } else {
                    isDirectory = false;
                    this.finStream = new FileInputStream(source);
                }
                if (!deployFile.startsWith(tempOutputDir)) continue;
                String fileName = deployFile.substring(tempOutputDir.length());
                targetPath = outputPath.append(fileName).makeAbsolute();
                if (isDirectory) {
                    ContentCopyUtils.makeFolderPathAtLocation(context, targetPath, monitor);
                    continue;
                }
                if (this.finStream != null) {
                    ContentCopyUtils.createFileAtLocation(context, targetPath, this.finStream, monitor);
                }
                this.finStream.close();
            }
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCoreUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCoreUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        return status;
    }

    private void visitAllDirsAndFiles(File dir) {
        this.fileAndDirectoriesList.add(dir.getAbsolutePath());
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                this.visitAllDirsAndFiles(new File(dir, children[i]));
            }
        }
    }

    private static IFolder makeFolder(ResourceContext resourceContext, IContainer parent, String folderName, IProgressMonitor progressMonitor) throws CoreException {
        IResource child = parent.findMember(folderName);
        if (child == null) {
            IFolder folder = parent.getFolder((IPath)new Path(folderName));
            folder.create(true, true, null);
            return folder;
        }
        if (child.getType() == 2) {
            return (IFolder)child;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)"ERROR", (Object[])new Object[]{parent.getFullPath().append(folderName).toString()}), null));
    }

    public static IContainer makeFolderPathAtLocation(ResourceContext resourceContext, IContainer resource, IProgressMonitor progressMonitor) throws CoreException {
        if (resource.exists()) {
            if (resource instanceof IContainer) {
                return resource;
            }
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)"ERROR", (Object[])new Object[]{resource.getFullPath().toString()}), null));
        }
        IContainer parent = ContentCopyUtils.makeFolderPathAtLocation(resourceContext, resource.getParent(), progressMonitor);
        String folderName = resource.getName();
        return ContentCopyUtils.makeFolder(resourceContext, parent, folderName, progressMonitor);
    }

    public static IContainer makeFolderPathAtLocation(ResourceContext resourceContext, IPath absolutePath, IProgressMonitor progressMonitor) throws CoreException {
        return ContentCopyUtils.makeFolderPathAtLocation(resourceContext, ContentCopyUtils.getWorkspaceRoot().getContainerForLocation(absolutePath), progressMonitor);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IFile createFileAtLocation(ResourceContext resourceContext, IPath absolutePath, InputStream inputStream, IProgressMonitor progressMonitor) throws CoreException {
        if (!absolutePath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)"ERROR", (Object[])new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)"ERROR", (Object[])new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)"ERROR", (Object[])new Object[]{absolutePath.toString()}), null));
        }
        IContainer parent = ContentCopyUtils.makeFolderPathAtLocation(resourceContext, absolutePath.removeLastSegments(1), progressMonitor);
        String fileName = absolutePath.lastSegment();
        return ContentCopyUtils.makeFile(resourceContext, parent, fileName, inputStream, progressMonitor);
    }

    private static IFile makeFile(ResourceContext resourceContext, IContainer parent, String fileName, InputStream inputStream, IProgressMonitor progressMonitor) throws CoreException {
        IResource child = parent.findMember(fileName);
        if (child != null) {
            if (child.getType() == 1) {
                if (child.getResourceAttributes().isReadOnly()) {
                    IFile[] files = new IFile[]{(IFile)child};
                }
                IFile file = parent.getFile((IPath)new Path(fileName));
                file.setContents(inputStream, true, true, null);
                return file;
            }
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)"ERROR", (Object[])new Object[]{parent.getFullPath().append(fileName)}), null));
        }
        IFile file = parent.getFile((IPath)new Path(fileName));
        file.create(inputStream, true, null);
        return file;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }
}

