/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.facet.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FacetContainerUtils;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;
import org.wso2.wsf.ide.facet.utils.ContentCopyUtils;
import org.wso2.wsf.ide.facet.utils.WSASWebappUtils;

public class WSASWebservicesServerCommand
extends AbstractDataModelOperation {
    String project;

    public WSASWebservicesServerCommand(String project) {
        this.project = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }

    public IStatus exexuteOverride(IProgressMonitor monitor) {
        IStatus status = null;
        String runtimeLocation = null;
        ContentCopyUtils contentCopyUtils = new ContentCopyUtils();
        try {
            runtimeLocation = WSASWebappUtils.copyWSASWar(monitor, WSASCoreUIMessages.PROPERTY_KEY_PATH, this.project);
        }
        catch (FileNotFoundException e) {
            return this.handleExceptionStatus(e);
        }
        catch (IOException e) {
            return this.handleExceptionStatus(e);
        }
        catch (Exception e) {
            return this.handleExceptionStatus(e);
        }
        status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(runtimeLocation, FacetContainerUtils.pathToWebProjectContainer(this.project), monitor);
        status = Status.OK_STATUS;
        File tempFacetDirectory = new File(runtimeLocation);
        if (tempFacetDirectory.exists()) {
            FileUtils.deleteDir(tempFacetDirectory);
        }
        return status;
    }

    private void cleanupIfFacetStatusFailed(String runtimeLocation) {
        File tempFacetDirectory = new File(runtimeLocation);
        if (tempFacetDirectory.exists()) {
            FileUtils.deleteDir(tempFacetDirectory);
        }
    }

    private IStatus handleExceptionStatus(Exception e) {
        Status status = null;
        status = new Status(1, this.project, 1, WSASCoreUIMessages.ERROR_SERVER_IS_NOT_SET, (Throwable)e);
        this.cleanupIfFacetStatusFailed(WSASCoreUtils.tempWSASDirectory());
        return status;
    }
}

