/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FileUtils;

public class WSASCoreUtils {
    private static boolean alreadyComputedTempWSASDirectory = false;
    private static String tempWSASDir = null;

    public static String tempWSASDirectory() {
        if (!alreadyComputedTempWSASDirectory) {
            String[] nodes = new String[]{WSASCoreUIMessages.DIR_DOT_METADATA, WSASCoreUIMessages.DIR_DOT_PLUGINS, WSASCoreUIMessages.TEMP_WSAS_FACET_DIR};
            tempWSASDir = FileUtils.addNodesToPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString(), nodes);
            alreadyComputedTempWSASDirectory = true;
        }
        return tempWSASDir;
    }

    public static String tempWSASWebappFileLocation() {
        return WSASCoreUtils.addAnotherNodeToPath(WSASCoreUtils.tempWSASDirectory(), WSASCoreUIMessages.WEBAPP_EXPLODED_SERVER_LOCATION_FILE);
    }

    public static String tempRuntimeStatusFileLocation() {
        return WSASCoreUtils.addAnotherNodeToPath(WSASCoreUtils.tempWSASDirectory(), WSASCoreUIMessages.SERVER_STATUS_LOCATION_FILE);
    }

    public static String tempWarStatusFileLocation() {
        return WSASCoreUtils.addAnotherNodeToPath(WSASCoreUtils.tempWSASDirectory(), WSASCoreUIMessages.WAR_STATUS_LOCATION_FILE);
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return currentPath + File.separator + newNode;
    }

    public static void writePropertyToFile(File file, String key, String value) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "8859_1"));
        out.write(key + "=" + value + "\n");
        ((Writer)out).close();
    }
}

