/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ScriptBuilder {
    public void parseXMLFile(String inFilename, String outFilename, String xslFilename) {
        try {
            this.parseXMLFile(new FileInputStream(inFilename), new FileOutputStream(outFilename), new FileInputStream(xslFilename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void parseXMLFile(InputStream inStream, OutputStream outStream, InputStream xslStream) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(new StreamSource(xslStream));
            Transformer xformer = template.newTransformer();
            StreamSource source = new StreamSource(inStream);
            StreamResult result = new StreamResult(outStream);
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            SourceLocator locator = e.getLocator();
            System.out.println("An error occurred while applying the XSL file : \nlocation column : " + locator.getColumnNumber() + "\n" + "line : " + locator.getLineNumber() + "\n" + "publicId : " + locator.getPublicId() + "\n" + "systemId: " + locator.getSystemId() + "\n");
            e.printStackTrace();
        }
    }
}

