/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;

public class RuntimePropertyUtils {
    private static File PropertiesFileDir;
    private static File serverPropertiesFile;
    private static File statusPropertyFile;
    private static File warPropertyFile;
    private static IStatus status;
    private static Properties properties;

    private static void init() {
        PropertiesFileDir = new File(WSASCoreUtils.tempWSASDirectory());
        if (!PropertiesFileDir.exists()) {
            PropertiesFileDir.mkdirs();
        }
        properties = new Properties();
    }

    private static void serverPropertiesFileInit() throws IOException {
        serverPropertiesFile = new File(WSASCoreUtils.tempWSASWebappFileLocation());
        if (!serverPropertiesFile.exists()) {
            serverPropertiesFile.createNewFile();
        }
        properties.load(new FileInputStream(serverPropertiesFile));
    }

    private static void statusPropertiesFileInit() throws IOException {
        statusPropertyFile = new File(WSASCoreUtils.tempRuntimeStatusFileLocation());
        if (!statusPropertyFile.exists()) {
            statusPropertyFile.createNewFile();
        }
        properties.load(new FileInputStream(statusPropertyFile));
    }

    private static void warPropertiesFileInit() throws IOException {
        warPropertyFile = new File(WSASCoreUtils.tempWarStatusFileLocation());
        if (!warPropertyFile.exists()) {
            warPropertyFile.createNewFile();
        }
        properties.load(new FileInputStream(warPropertyFile));
    }

    public static IStatus writeServerPathToPropertiesFile(String wsasPath) {
        String wsasPathNew = null;
        wsasPathNew = wsasPath.indexOf("\\") != -1 ? wsasPath.replace(File.separator, File.separator + File.separator) : wsasPath;
        try {
            RuntimePropertyUtils.init();
            RuntimePropertyUtils.serverPropertiesFileInit();
            if (properties.size() != 0 && properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_PATH)) {
                properties.remove(WSASCoreUIMessages.PROPERTY_KEY_PATH);
            }
            WSASCoreUtils.writePropertyToFile(serverPropertiesFile, WSASCoreUIMessages.PROPERTY_KEY_PATH, wsasPathNew);
        }
        catch (FileNotFoundException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        return status;
    }

    public static String getServerPathFromPropertiesFile() {
        RuntimePropertyUtils.init();
        String serverPath = null;
        serverPropertiesFile = new File(WSASCoreUtils.tempWSASWebappFileLocation());
        if (!serverPropertiesFile.exists()) {
            RuntimePropertyUtils.updateStatusError();
        }
        try {
            properties.load(new FileInputStream(serverPropertiesFile));
            if (properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_PATH)) {
                serverPath = properties.getProperty(WSASCoreUIMessages.PROPERTY_KEY_PATH);
            }
        }
        catch (FileNotFoundException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        return serverPath;
    }

    public static IStatus writeServerStausToPropertiesFile(String runtimeStatus) {
        try {
            RuntimePropertyUtils.init();
            RuntimePropertyUtils.statusPropertiesFileInit();
            if (properties.size() != 0 && properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_STATUS)) {
                properties.remove(WSASCoreUIMessages.PROPERTY_KEY_STATUS);
            }
            WSASCoreUtils.writePropertyToFile(statusPropertyFile, WSASCoreUIMessages.PROPERTY_KEY_STATUS, runtimeStatus);
        }
        catch (FileNotFoundException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        return status;
    }

    public static IStatus writeWarStausToPropertiesFile(boolean warStatus) {
        try {
            RuntimePropertyUtils.init();
            RuntimePropertyUtils.warPropertiesFileInit();
            if (properties.size() != 0 && properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_STATUS)) {
                properties.remove(WSASCoreUIMessages.PROPERTY_KEY_STATUS);
            }
            WSASCoreUtils.writePropertyToFile(warPropertyFile, WSASCoreUIMessages.PROPERTY_KEY_STATUS, String.valueOf(warStatus));
        }
        catch (FileNotFoundException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        return status;
    }

    public static boolean getWarStatusFromPropertiesFile() {
        RuntimePropertyUtils.init();
        boolean warStatus = false;
        warPropertyFile = new File(WSASCoreUtils.tempWarStatusFileLocation());
        if (!warPropertyFile.exists()) {
            RuntimePropertyUtils.updateStatusError();
        }
        try {
            properties.load(new FileInputStream(warPropertyFile));
            if (properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_STATUS)) {
                warStatus = Boolean.parseBoolean(properties.getProperty(WSASCoreUIMessages.PROPERTY_KEY_STATUS));
            }
        }
        catch (FileNotFoundException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException e) {
            RuntimePropertyUtils.updateStatusError();
        }
        return warStatus;
    }

    private static void updateStatusError() {
        status = new Status(4, "id", 0, WSASCoreUIMessages.ERROR_INVALID_WSAS_SERVER_LOCATION, null);
    }
}

