/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) {
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            is = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            int c = 0;
            byte[] array = new byte[1024];
            while ((c = ((InputStream)is).read(array)) >= 0) {
                fos.write(array, 0, c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
                ((InputStream)is).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File createFileAndParentDirectories(String fileName) throws Exception {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        return file;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteDirectories(File dir) {
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].list() != null && children[i].list().length > 0) {
                FileUtils.deleteDirectories(children[i]);
                continue;
            }
            children[i].delete();
        }
        dir.delete();
    }

    public static void deleteDirectories(String dir) {
        File directory = new File(dir);
        FileUtils.deleteDirectories(directory);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName) throws Exception {
        FileUtils.createTargetFile(sourceFileName, targetFileName, false);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName, boolean overwrite) throws Exception {
        File idealResultFile = new File(targetFileName);
        if (overwrite || !idealResultFile.exists()) {
            FileUtils.createFileAndParentDirectories(targetFileName);
            FileUtils.copyFile(sourceFileName, targetFileName);
        }
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        if (!success) {
            // empty if block
        }
        return success;
    }

    public static boolean createDirectorys(String directory) {
        boolean success = new File(directory).mkdirs();
        if (!success) {
            // empty if block
        }
        return success;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileUtils.copy(srcDir, dstDir);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return currentPath + File.separator + newNode;
    }

    public static String addNodesToPath(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        for (int i = 0; i < newNode.length; ++i) {
            returnPath = returnPath + File.separator + newNode[i];
        }
        return returnPath;
    }

    public static String addNodesToPath(StringBuffer currentPath, String[] pathNodes) {
        for (int i = 0; i < pathNodes.length; ++i) {
            currentPath.append(File.separator);
            currentPath.append(pathNodes[i]);
        }
        return currentPath.toString();
    }

    public static String addNodesToURL(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        for (int i = 0; i < newNode.length; ++i) {
            returnPath = returnPath + "/" + newNode[i];
        }
        return returnPath;
    }

    public static File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        String[] items = libDir.list();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                if (fileNamePrefix != null && extension != null) {
                    if (!item.startsWith(fileNamePrefix) || !item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix == null && extension != null) {
                    if (!item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix != null && extension == null) {
                    if (!item.startsWith(fileNamePrefix)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                fileList.add(new File(libDirPath + File.separator + item));
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static void filterOutRestrictedFiles(String sourceDir, String fileNamePrefix, String extension) {
        File[] resultedMatchingFiles = FileUtils.getMatchingFiles(sourceDir, fileNamePrefix, extension);
        for (int i = 0; i < resultedMatchingFiles.length; ++i) {
            File matchingFilePath = new File(resultedMatchingFiles[i].getAbsolutePath());
            matchingFilePath.delete();
        }
    }

    public static List<IPath> getDirsOnly(String sourceDir) {
        ArrayList<IPath> resultList = new ArrayList<IPath>();
        File srcDir = new File(sourceDir);
        if (srcDir.exists()) {
            File[] listOfFilesAndDirs = srcDir.listFiles();
            for (int i = 0; i < listOfFilesAndDirs.length; ++i) {
                IPath pathWithOutLastSegment;
                Path pathInstance = new Path(listOfFilesAndDirs[i].getAbsolutePath());
                if (listOfFilesAndDirs[i].getAbsolutePath() == null || !new File(listOfFilesAndDirs[i].getAbsolutePath()).isDirectory() || (pathWithOutLastSegment = pathInstance.removeLastSegments(1)) == null || !pathWithOutLastSegment.toOSString().equals(sourceDir)) continue;
                resultList.add((IPath)pathInstance);
            }
        }
        return resultList;
    }
}

