/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;

public class FacetContainerUtils {
    public static String pathToWebProjectContainer(String project) {
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String projectString = FacetContainerUtils.replaceEscapecharactors(project.toString());
        String currentDynamicWebProjectDir = WSASCoreUtils.addAnotherNodeToPath(workspaceDirectory, FacetContainerUtils.getProjectNameFromFramewokNameString(projectString));
        String webContainerDirString = WSASCoreUtils.addAnotherNodeToPath(currentDynamicWebProjectDir, WSASCoreUIMessages.DIR_WEBCONTENT);
        return webContainerDirString;
    }

    public static String pathToWebProjectContainerLib(String project) {
        String webContainerWEBINFString = WSASCoreUtils.addAnotherNodeToPath(FacetContainerUtils.pathToWebProjectContainer(project), WSASCoreUIMessages.DIR_WEB_INF);
        return WSASCoreUtils.addAnotherNodeToPath(webContainerWEBINFString, WSASCoreUIMessages.DIR_LIB);
    }

    private static String replaceEscapecharactors(String vulnarableString) {
        if (vulnarableString.indexOf("/") != -1) {
            vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
        }
        return vulnarableString;
    }

    private static String getProjectNameFromFramewokNameString(String frameworkProjectString) {
        if (frameworkProjectString.indexOf(FacetContainerUtils.getSplitCharactor()) == -1) {
            return frameworkProjectString;
        }
        return frameworkProjectString.split(FacetContainerUtils.getSplitCharactors())[1];
    }

    private static String getSplitCharactor() {
        if (File.separatorChar == '\\') {
            return "\\";
        }
        return File.separator;
    }

    private static String getSplitCharactors() {
        if (File.separatorChar == '\\') {
            return "\\" + File.separator;
        }
        return File.separator;
    }

    public static String getDeployedWSDLURL(String projectName, String serviceName) {
        String[] deployedWSDLURLParts = new String[]{WSASCoreUIMessages.SERVICES, serviceName};
        return FileUtils.addNodesToURL(WSASCoreUIMessages.LOCAL_SERVER_PORT, deployedWSDLURLParts) + "?wsdl";
    }
}

