/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.wso2.wsf.ide.core.context.WSASEmitterContext;
import org.wso2.wsf.ide.core.plugin.WebServiceWSASCorePlugin;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FileUtils;

public class ClassLoadingUtil {
    private static String[] wsasClassPath = null;
    private static String[] classLoadPath = null;
    private static int libCount = 0;
    private static AntClassLoader antClassLoader;
    private static boolean libsLoaded;
    private static URL[] urls;
    private static boolean alreadyInit;
    private static boolean initByClient;

    public static void init() {
        if (!alreadyInit) {
            if (antClassLoader == null) {
                antClassLoader = new AntClassLoader();
            }
            antClassLoader.setParentFirst(false);
            if (wsasClassPath != null || !libsLoaded) {
                classLoadPath = ClassLoadingUtil.getWSASLibs();
            }
            if (urls == null) {
                urls = new URL[classLoadPath.length];
            }
            Path classpath = new Path(new Project());
            try {
                for (int i = 0; i < classLoadPath.length; ++i) {
                    URL url;
                    if (classLoadPath[i] == null) continue;
                    File file = new File(classLoadPath[i]);
                    ClassLoadingUtil.urls[i] = url = file.toURL();
                    classpath.setPath(classLoadPath[i]);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            antClassLoader.setClassPath(classpath);
            alreadyInit = true;
        }
    }

    public static Class loadClassFromAntClassLoader(String fillyQualifiedClassName) {
        Class cls = null;
        try {
            cls = antClassLoader.loadClass(fillyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return cls;
    }

    private static String[] getWSASLibs() {
        WSASEmitterContext context = WebServiceWSASCorePlugin.getDefault().getWSASEmitterContext();
        if (context.isCorrectWSASPathSet()) {
            File libraryPath = new File(FileUtils.addAnotherNodeToPath(context.getWSASRuntimeLocation(), WSASCoreUIMessages.DIR_LIB));
            wsasClassPath = new String[libraryPath.list().length + 10];
            libCount = 0;
            ClassLoadingUtil.visitAllFiles(libraryPath);
        }
        return wsasClassPath;
    }

    public static void visitAllFiles(File dir) {
        if (!dir.toString().endsWith(".txt")) {
            if (dir.isDirectory()) {
                if (!(dir.getName().toString().equals("tomcat") || dir.getName().toString().equals("wsf") || dir.getName().toString().equals("patches"))) {
                    String[] children = dir.list();
                    for (int i = 0; i < children.length; ++i) {
                        ClassLoadingUtil.visitAllFiles(new File(dir, children[i]));
                    }
                }
            } else {
                ClassLoadingUtil.wsasClassPath[ClassLoadingUtil.libCount] = dir.getAbsolutePath();
                ++libCount;
            }
        }
        libsLoaded = true;
    }

    public static void cleanAntClassLoader() {
        if (initByClient) {
            antClassLoader.cleanup();
            alreadyInit = false;
        }
    }

    public static void setInitByClient(boolean status) {
        initByClient = status;
    }

    static {
        libsLoaded = false;
        urls = null;
        alreadyInit = false;
        initByClient = false;
    }
}

