/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ArchiveManipulator {
    protected String archiveSourceDir;

    public void archiveDir(String destArchiveName, String sourceDir) throws IOException {
        File zipDir = new File(sourceDir);
        if (!zipDir.isDirectory()) {
            throw new RuntimeException(sourceDir + " is not a directory");
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destArchiveName));
        this.archiveSourceDir = sourceDir;
        this.zipDir(zipDir, zos);
        zos.close();
    }

    public void archiveFile(String from, String to) throws IOException {
        int bytesRead;
        FileInputStream in = new FileInputStream(from);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(to));
        byte[] buffer = new byte[40960];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] check(String archive) throws IOException {
        ZipInputStream zin = null;
        FileInputStream in = null;
        ArrayList<String> entries = new ArrayList<String>();
        try {
            ZipEntry entry;
            in = new FileInputStream(archive);
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                entries.add(entry.getName());
            }
            String[] stringArray = entries.toArray(new String[entries.size()]);
            return stringArray;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                System.err.println("Could not close InputStream " + e);
            }
        }
    }

    public void extract(String archive, String extractDir) throws IOException {
        FileInputStream inputStream = new FileInputStream(archive);
        this.extractFromStream(inputStream, extractDir);
    }

    public void extractFromStream(InputStream inputStream, String extractDir) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            File unzipped = new File(extractDir);
            zin = new ZipInputStream(inputStream);
            unzipped.mkdirs();
            while ((entry = zin.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                File f = new File(extractDir + File.separator + entryName);
                if (entryName.endsWith("/") && !f.exists()) {
                    f.mkdirs();
                    continue;
                }
                int lastIndexOfSlash = entryName.lastIndexOf("/");
                String dirPath = "";
                if (lastIndexOfSlash != -1) {
                    dirPath = entryName.substring(0, lastIndexOfSlash);
                    File dir = new File(extractDir + File.separator + dirPath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                }
                if (f.isDirectory()) continue;
                FileOutputStream out = new FileOutputStream(f);
                byte[] buf = new byte[40960];
                while ((len = zin.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
        catch (IOException e) {
            String msg = "Cannot unzip archive. It is probably corrupt";
            System.err.println(msg);
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void zipDir(File zipDir, ZipOutputStream zos) throws IOException {
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[40960];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            zos.putNextEntry(new ZipEntry(this.getZipEntryPath(f)));
            if (f.isDirectory()) {
                this.zipDir(f, zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    private String getZipEntryPath(File f) {
        String entryPath = f.getPath();
        entryPath = entryPath.substring(this.archiveSourceDir.length() + 1);
        if (File.separatorChar == '\\') {
            entryPath = entryPath.replace(File.separatorChar, '/');
        }
        if (f.isDirectory()) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }
}

