/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SAMLNameIdentifierCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SAMLTokenIssuer
implements TokenIssuer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPEnvelope issue(RahasData data) throws TrustException {
        try {
            Token assertionToken;
            OMElement rstrElem;
            SAMLAssertion assertion;
            MessageContext inMsgCtx = data.getInMessageContext();
            SAMLTokenIssuerConfig config = null;
            if (this.configElement != null) {
                config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            }
            if (config == null && this.configFile != null) {
                config = new SAMLTokenIssuerConfig(this.configFile);
            }
            if (config == null && this.configParamName != null) {
                Parameter param = inMsgCtx.getParameter(this.configParamName);
                if (param != null && param.getParameterElement() != null) {
                    config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
                } else {
                    throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
                }
            }
            if (config == null) {
                throw new TrustException("configurationIsNull");
            }
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
            Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
            Date creationTime = new Date();
            Date expirationTime = new Date();
            expirationTime.setTime(creationTime.getTime() + config.ttl);
            Document doc = ((Element)env).getOwnerDocument();
            int keySize = data.getKeysize();
            keySize = keySize == -1 ? config.keySize : keySize;
            String keyType = data.getKeyType();
            if (keyType == null) {
                throw new TrustException("InvalidRequest", new String[]{"Requested KeyType is missing"});
            }
            if (keyType.endsWith("/SymmetricKey") || keyType.endsWith("/PublicKey")) {
                assertion = this.createHoKAssertion(config, doc, crypto, creationTime, expirationTime, data);
            } else if (keyType.endsWith("/Bearer")) {
                assertion = this.createBearerAssertion(config, doc, crypto, creationTime, expirationTime, data);
            } else {
                throw new TrustException("unsupportedKeyType");
            }
            int wstVersion = data.getVersion();
            if (1 == wstVersion) {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            } else {
                OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
            }
            TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            if (keyType.endsWith("/SymmetricKey")) {
                TrustUtil.createKeySizeElement(wstVersion, rstrElem, keySize);
            }
            if (config.addRequestedAttachedRef) {
                TrustUtil.createRequestedAttachedRef(wstVersion, rstrElem, "#" + assertion.getId(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            }
            if (config.addRequestedUnattachedRef) {
                TrustUtil.createRequestedUnattachedRef(wstVersion, rstrElem, assertion.getId(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            }
            if (data.getAppliesToAddress() != null) {
                TrustUtil.createAppliesToElement(rstrElem, data.getAppliesToAddress(), data.getAddressingNs());
            }
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
            OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            try {
                Node tempNode = assertion.toDOM();
                reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
                assertionToken = new Token(assertion.getId(), (OMElement)assertion.toDOM(), creationTime, expirationTime);
                assertionToken.setSecret(data.getEphmeralKey());
                TrustUtil.getTokenStore(inMsgCtx).add(assertionToken);
            }
            catch (SAMLException e) {
                throw new TrustException("samlConverstionError", e);
            }
            if (keyType.endsWith("/SymmetricKey") && config.keyComputation != 1) {
                TokenIssuerUtil.handleRequestedProofToken(data, wstVersion, config, rstrElem, assertionToken, doc);
            }
            SOAPEnvelope sOAPEnvelope = env;
            return sOAPEnvelope;
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
    }

    private SAMLAssertion createBearerAssertion(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, Date creationTime, Date expirationTime, RahasData data) throws TrustException {
        try {
            Principal principal = data.getPrincipal();
            if (principal instanceof WSUsernameTokenPrincipal) {
                SAMLNameIdentifier nameId = null;
                if (config.getCallbackHander() != null) {
                    SAMLNameIdentifierCallback cb = new SAMLNameIdentifierCallback(data);
                    cb.setUserId(principal.getName());
                    SAMLCallbackHandler callbackHandler = config.getCallbackHander();
                    callbackHandler.handle(cb);
                    nameId = cb.getNameId();
                } else {
                    nameId = new SAMLNameIdentifier(principal.getName(), null, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                }
                return this.createAuthAssertion(doc, "urn:oasis:names:tc:SAML:1.0:cm:bearer", nameId, null, config, crypto, creationTime, expirationTime);
            }
            throw new TrustException("samlUnsupportedPrincipal", new String[]{principal.getClass().getName()});
        }
        catch (SAMLException e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    private SAMLAssertion createHoKAssertion(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, Date creationTime, Date expirationTime, RahasData data) throws TrustException {
        if (data.getKeyType().endsWith("/SymmetricKey")) {
            Element encryptedKeyElem;
            X509Certificate serviceCert = null;
            try {
                serviceCert = this.getServiceCert(config, crypto, data.getAppliesToAddress());
                WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
                encrKeyBuilder.setKeyIdentifierType(8);
                encrKeyBuilder.setUseThisCert(serviceCert);
                int keysize = data.getKeysize();
                keysize = keysize != -1 ? keysize : config.keySize;
                encrKeyBuilder.setKeySize(keysize);
                encrKeyBuilder.setEphemeralKey(TokenIssuerUtil.getSharedSecret(data, config.keyComputation, keysize));
                encrKeyBuilder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
                encrKeyBuilder.prepare(doc, crypto);
                byte[] tempKey = new byte[keysize / 8];
                System.arraycopy(encrKeyBuilder.getEphemeralKey(), 0, tempKey, 0, keysize / 8);
                data.setEphmeralKey(tempKey);
                encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{serviceCert.getSubjectDN().getName()}, e);
            }
            return this.createAttributeAssertion(doc, data, encryptedKeyElem, config, crypto, creationTime, expirationTime);
        }
        try {
            String subjectNameId = data.getPrincipal().getName();
            SAMLNameIdentifier nameId = new SAMLNameIdentifier(subjectNameId, null, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            X509Certificate clientCert = data.getClientCert();
            if (clientCert == null) {
                X509Certificate[] certs = crypto.getCertificates(data.getPrincipal().getName());
                clientCert = certs[0];
            }
            byte[] clientCertBytes = clientCert.getEncoded();
            String base64Cert = Base64.encode((byte[])clientCertBytes);
            Text base64CertText = doc.createTextNode(base64Cert);
            Element x509CertElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            x509CertElem.appendChild(base64CertText);
            Element x509DataElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            x509DataElem.appendChild(x509CertElem);
            return this.createAuthAssertion(doc, "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key", nameId, x509DataElem, config, crypto, creationTime, expirationTime);
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    private X509Certificate getServiceCert(SAMLTokenIssuerConfig config, Crypto crypto, String serviceAddress) throws WSSecurityException {
        if (serviceAddress != null && !"".equals(serviceAddress)) {
            String alias = (String)config.trustedServices.get(serviceAddress);
            if (alias != null) {
                return crypto.getCertificates(alias)[0];
            }
            alias = (String)config.trustedServices.get("*");
            return crypto.getCertificates(alias)[0];
        }
        String alias = (String)config.trustedServices.get("*");
        return crypto.getCertificates(alias)[0];
    }

    private SAMLAssertion createAttributeAssertion(Document doc, RahasData data, Element keyInfoContent, SAMLTokenIssuerConfig config, Crypto crypto, Date notBefore, Date notAfter) throws TrustException {
        try {
            String[] confirmationMethods = new String[]{"urn:oasis:names:tc:SAML:1.0:cm:holder-of-key"};
            Element keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
            ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
            ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc");
            keyInfoElem.appendChild(keyInfoContent);
            SAMLSubject subject = new SAMLSubject(null, Arrays.asList(confirmationMethods), null, (Object)keyInfoElem);
            SAMLAttribute[] attrs = null;
            if (config.getCallbackHander() != null) {
                SAMLAttributeCallback cb = new SAMLAttributeCallback(data);
                SAMLCallbackHandler handler = config.getCallbackHander();
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else {
                SAMLAttribute attribute = new SAMLAttribute("Name", "https://rahas.apache.org/saml/attrns", null, -1L, Arrays.asList("Colombo/Rahas"));
                attrs = new SAMLAttribute[]{attribute};
            }
            SAMLAttributeStatement attrStmt = new SAMLAttributeStatement(subject, Arrays.asList(attrs));
            SAMLStatement[] statements = new SAMLStatement[]{attrStmt};
            SAMLAssertion assertion = new SAMLAssertion(config.issuerName, notBefore, notAfter, null, null, Arrays.asList(statements));
            X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            assertion.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    private SAMLAssertion createAuthAssertion(Document doc, String confMethod, SAMLNameIdentifier subjectNameId, Element keyInfoContent, SAMLTokenIssuerConfig config, Crypto crypto, Date notBefore, Date notAfter) throws TrustException {
        try {
            String[] confirmationMethods = new String[]{confMethod};
            Element keyInfoElem = null;
            if (keyInfoContent != null) {
                keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
                ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc");
                keyInfoElem.appendChild(keyInfoContent);
            }
            SAMLSubject subject = new SAMLSubject(subjectNameId, Arrays.asList(confirmationMethods), null, (Object)keyInfoElem);
            SAMLAuthenticationStatement authStmt = new SAMLAuthenticationStatement(subject, "urn:oasis:names:tc:SAML:1.0:am:password", notBefore, null, null, null);
            SAMLStatement[] statements = new SAMLStatement[]{authStmt};
            SAMLAssertion assertion = new SAMLAssertion(config.issuerName, notBefore, notAfter, null, null, Arrays.asList(statements));
            X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            assertion.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    public String getResponseAction(RahasData data) throws TrustException {
        return TrustUtil.getActionValue(data.getVersion(), "/RSTR/Issue");
    }

    protected byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("Error in creating the ephemeral key", e);
        }
    }

    public void setConfigurationFile(String configFile) {
    }

    public void setConfigurationElement(OMElement configElement) {
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }
}

