/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.rahas.TrustException;
import org.apache.ws.security.util.XmlSchemaDateFormat;

public class Token {
    public static final int ISSUED = 1;
    public static final int EXPIRED = 2;
    public static final int CANCELLED = 3;
    public static final int RENEWED = 4;
    private String id;
    private int state = -1;
    private OMElement token;
    private OMElement previousToken;
    private OMElement attachedReference;
    private OMElement unattachedReference;
    private Properties properties;
    private boolean changed;
    private byte[] secret;
    private Date created;
    private Date expires;
    private String issuerAddress;
    private String encrKeySha1Value;

    public Token(String id, Date created, Date expires) {
        this.id = id;
        this.created = created;
        this.expires = expires;
    }

    public Token(String id, OMElement tokenElem, Date created, Date expires) throws TrustException {
        this.id = id;
        this.token = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), tokenElem.getXMLStreamReader()).getDocumentElement();
        this.created = created;
        this.expires = expires;
    }

    public Token(String id, OMElement tokenElem, OMElement lifetimeElem) throws TrustException {
        this.id = id;
        this.token = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), tokenElem.getXMLStreamReader()).getDocumentElement();
        this.processLifeTime(lifetimeElem);
    }

    private void processLifeTime(OMElement lifetimeElem) throws TrustException {
        try {
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            OMElement createdElem = lifetimeElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created"));
            this.created = zulu.parse(createdElem.getText());
            OMElement expiresElem = lifetimeElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires"));
            this.expires = zulu.parse(expiresElem.getText());
        }
        catch (OMException e) {
            throw new TrustException("lifeTimeProcessingError", new String[]{lifetimeElem.toString()}, e);
        }
        catch (ParseException e) {
            throw new TrustException("lifeTimeProcessingError", new String[]{lifetimeElem.toString()}, e);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean chnaged) {
        this.changed = chnaged;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public OMElement getToken() {
        return this.token;
    }

    public void setToken(OMElement token) {
        this.token = token;
    }

    public String getId() {
        return this.id;
    }

    public OMElement getPreviousToken() {
        return this.previousToken;
    }

    public void setPreviousToken(OMElement presivousToken) {
        this.previousToken = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), presivousToken.getXMLStreamReader()).getDocumentElement();
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public void setSecret(byte[] secret) {
        this.secret = secret;
    }

    public OMElement getAttachedReference() {
        return this.attachedReference;
    }

    public void setAttachedReference(OMElement attachedReference) {
        if (attachedReference != null) {
            this.attachedReference = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), attachedReference.getXMLStreamReader()).getDocumentElement();
        }
    }

    public OMElement getUnattachedReference() {
        return this.unattachedReference;
    }

    public void setUnattachedReference(OMElement unattachedReference) {
        if (unattachedReference != null) {
            this.unattachedReference = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), unattachedReference.getXMLStreamReader()).getDocumentElement();
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public String getIssuerAddress() {
        return this.issuerAddress;
    }

    public void setIssuerAddress(String issuerAddress) {
        this.issuerAddress = issuerAddress;
    }
}

