/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.ws.security.message.token.Reference;

public class SimpleTokenStore
implements TokenStorage {
    protected Map tokens = new Hashtable();

    public void add(Token token) throws TrustException {
        if (token != null && !"".equals(token.getId()) && token.getId() != null) {
            if (this.tokens.keySet().size() == 0 || this.tokens.keySet().size() > 0 && !this.tokens.keySet().contains(token.getId())) {
                this.tokens.put(token.getId(), token);
            } else {
                throw new TrustException("tokenAlreadyExists", new String[]{token.getId()});
            }
        }
    }

    public void update(Token token) throws TrustException {
        if (token != null && token.getId() != null && token.getId().trim().length() != 0) {
            if (!this.tokens.keySet().contains(token.getId())) {
                throw new TrustException("noTokenToUpdate", new String[]{token.getId()});
            }
            this.tokens.put(token.getId(), token);
        }
    }

    public String[] getTokenIdentifiers() throws TrustException {
        ArrayList identifiers = new ArrayList();
        Iterator iterator = this.tokens.keySet().iterator();
        while (iterator.hasNext()) {
            identifiers.add(iterator.next());
        }
        return identifiers.toArray(new String[identifiers.size()]);
    }

    public Token[] getValidTokens() throws TrustException {
        return this.getTokens(new int[]{1, 4});
    }

    public Token[] getRenewedTokens() throws TrustException {
        return this.getTokens(4);
    }

    public Token[] getCancelledTokens() throws TrustException {
        return this.getTokens(3);
    }

    public Token[] getExpiredTokens() throws TrustException {
        return this.getTokens(2);
    }

    private Token[] getTokens(int[] states) throws TrustException {
        this.processTokenExpiry();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Iterator iterator = this.tokens.values().iterator();
        block0: while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            for (int i = 0; i < states.length; ++i) {
                if (token.getState() != states[i]) continue;
                tokens.add(token);
                continue block0;
            }
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    private Token[] getTokens(int state) throws TrustException {
        this.processTokenExpiry();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Iterator iterator = this.tokens.values().iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (token.getState() != state) continue;
            tokens.add(token);
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public Token getToken(String id) throws TrustException {
        this.processTokenExpiry();
        Token token = (Token)this.tokens.get(id);
        if (token == null) {
            Iterator iterator = this.tokens.values().iterator();
            while (iterator.hasNext()) {
                Token tempToken = (Token)iterator.next();
                OMElement elem = tempToken.getAttachedReference();
                if (elem != null) {
                    if (id.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                        token = tempToken;
                    }
                }
                if ((elem = tempToken.getUnattachedReference()) == null) continue;
                if (!id.equals(SimpleTokenStore.getIdFromSTR(elem))) continue;
                token = tempToken;
            }
        }
        return token;
    }

    protected void processTokenExpiry() throws TrustException {
        Iterator iterator = this.tokens.values().iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (token.getExpires() == null || token.getExpires().getTime() >= System.currentTimeMillis()) continue;
            token.setState(2);
            this.update(token);
        }
    }

    public static String getIdFromSTR(OMElement str) {
        OMElement child = str.getFirstElement();
        if (child == null) {
            return null;
        }
        if (child.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"))) {
            return child.getText();
        }
        if (child.getQName().equals(Reference.TOKEN)) {
            return child.getAttributeValue(new QName("URI")).substring(1);
        }
        return null;
    }
}

