/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.statistics.service;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.wso2.statistics.Counter;
import org.wso2.statistics.module.ResponseTimeProcessor;
import org.wso2.statistics.module.StatisticsModule;
import org.wso2.statistics.service.StatisticsServiceMBean;
import org.wso2.utils.AbstractAdmin;
import org.wso2.utils.MBeanRegistrar;

public class StatisticsService
extends AbstractAdmin
implements StatisticsServiceMBean {
    public int getSystemRequestCount() throws AxisFault {
        Object value;
        Parameter globalCounter = this.getAxisConfig().getParameter("wso2statistics.GlobalRequestCounter");
        if (globalCounter != null && (value = globalCounter.getValue()) instanceof Counter) {
            return ((Counter)value).getCount();
        }
        return 0;
    }

    public int getSystemFaultCount() throws AxisFault {
        Object value;
        Parameter globalCounter = this.getAxisConfig().getParameter("wso2statistics.GlobalFaultCounter");
        if (globalCounter != null && (value = globalCounter.getValue()) instanceof Counter) {
            return ((Counter)value).getCount();
        }
        return 0;
    }

    public int getSystemResponseCount() throws AxisFault {
        Object value;
        Parameter globalCounter = this.getAxisConfig().getParameter("wso2statistics.GlobalResponseCounter");
        if (globalCounter != null && (value = globalCounter.getValue()) instanceof Counter) {
            return ((Counter)value).getCount();
        }
        return 0;
    }

    public double getAvgSystemResponseTime() {
        return StatisticsModule.responseTimeProcessor.getAvgResponseTime();
    }

    public long getMaxSystemResponseTime() {
        return StatisticsModule.responseTimeProcessor.getMaxResponseTime();
    }

    public long getMinSystemResponseTime() {
        return StatisticsModule.responseTimeProcessor.getMinResponseTime();
    }

    public int getServiceRequestCount(String serviceName) throws AxisFault {
        Parameter parameter = this.getAxisService(serviceName).getParameter("wso2statistics.ServiceRequestCounter");
        if (parameter != null) {
            return ((Counter)parameter.getValue()).getCount();
        }
        return 0;
    }

    public int getServiceFaultCount(String serviceName) throws AxisFault {
        Parameter parameter = this.getAxisService(serviceName).getParameter("wso2statistics.ServiceFaultCounter");
        if (parameter != null) {
            return ((Counter)parameter.getValue()).getCount();
        }
        return 0;
    }

    public int getServiceResponseCount(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        int count = 0;
        Iterator opIter = axisService.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOp = (AxisOperation)opIter.next();
            Parameter parameter = axisOp.getParameter("wso2statistics.OutOperationCounter");
            if (parameter == null) continue;
            count += ((Counter)parameter.getValue()).getCount();
        }
        return count;
    }

    public long getMaxServiceResponseTime(String serviceName) throws AxisFault {
        long max = 0L;
        Parameter parameter = this.getAxisService(serviceName).getParameter("wso2statistics.ServiceResponseTimeProc");
        if (parameter != null) {
            ResponseTimeProcessor proc = (ResponseTimeProcessor)parameter.getValue();
            max = proc.getMaxResponseTime();
        }
        return max;
    }

    public long getMinServiceResponseTime(String serviceName) throws AxisFault {
        long min = 0L;
        Parameter parameter = this.getAxisService(serviceName).getParameter("wso2statistics.ServiceResponseTimeProc");
        if (parameter != null) {
            ResponseTimeProcessor proc = (ResponseTimeProcessor)parameter.getValue();
            min = proc.getMinResponseTime();
        }
        return min;
    }

    public double getAvgServiceResponseTime(String serviceName) throws AxisFault {
        double avg = 0.0;
        Parameter parameter = this.getAxisService(serviceName).getParameter("wso2statistics.ServiceResponseTimeProc");
        if (parameter != null) {
            ResponseTimeProcessor proc = (ResponseTimeProcessor)parameter.getValue();
            avg = proc.getAvgResponseTime();
        }
        return avg;
    }

    public int getOperationRequestCount(String serviceName, String operationName) throws AxisFault {
        AxisOperation axisOperation = this.getAxisOperation(serviceName, operationName);
        Parameter parameter = axisOperation.getParameter("wso2statistics.InOperationCounter");
        if (parameter != null) {
            return ((Counter)parameter.getValue()).getCount();
        }
        return 0;
    }

    public int getOperationFaultCount(String serviceName, String operationName) throws AxisFault {
        AxisOperation axisOperation = this.getAxisOperation(serviceName, operationName);
        Parameter parameter = axisOperation.getParameter("wso2statistics.OperationFaultCounter");
        if (parameter != null) {
            return ((Counter)parameter.getValue()).getCount();
        }
        return 0;
    }

    public int getOperationResponseCount(String serviceName, String operationName) throws AxisFault {
        AxisOperation axisOperation = this.getAxisOperation(serviceName, operationName);
        Parameter parameter = axisOperation.getParameter("wso2statistics.OutOperationCounter");
        if (parameter != null) {
            return ((Counter)parameter.getValue()).getCount();
        }
        return 0;
    }

    public long getMaxOperationResponseTime(String serviceName, String operationName) throws AxisFault {
        long max = 0L;
        Parameter parameter = this.getAxisOperation(serviceName, operationName).getParameter("wso2statistics.OperationResponseTimeProc");
        if (parameter != null) {
            max = ((ResponseTimeProcessor)parameter.getValue()).getMaxResponseTime();
        }
        return max;
    }

    public long getMinOperationResponseTime(String serviceName, String operationName) throws AxisFault {
        long min = 0L;
        Parameter parameter = this.getAxisOperation(serviceName, operationName).getParameter("wso2statistics.OperationResponseTimeProc");
        if (parameter != null) {
            min = ((ResponseTimeProcessor)parameter.getValue()).getMinResponseTime();
        }
        return min;
    }

    public double getAvgOperationResponseTime(String serviceName, String operationName) throws AxisFault {
        double avg = 0.0;
        Parameter parameter = this.getAxisOperation(serviceName, operationName).getParameter("wso2statistics.OperationResponseTimeProc");
        if (parameter != null) {
            avg = ((ResponseTimeProcessor)parameter.getValue()).getAvgResponseTime();
        }
        return avg;
    }

    private AxisService getAxisService(String serviceName) {
        return this.getAxisConfig().getServiceForActivation(serviceName);
    }

    private AxisOperation getAxisOperation(String serviceName, String operationName) {
        return this.getAxisService(serviceName).getOperation(new QName(operationName));
    }

    static {
        MBeanRegistrar.registerMBean((Object)new StatisticsService());
    }
}

