/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.statistics.module;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.statistics.Counter;
import org.wso2.statistics.module.ResponseTimeProcessor;
import org.wso2.statistics.module.StatisticsModule;

public class ResponseTimeHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog((Class)ResponseTimeHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        this.calculateResponseTimes(msgContext);
        return Handler.InvocationResponse.CONTINUE;
    }

    public void flowComplete(MessageContext msgContext) {
        String mep;
        AxisOperation axisOp;
        OperationContext opContext;
        if (msgContext != null && (opContext = msgContext.getOperationContext()) != null && (axisOp = opContext.getAxisOperation()) != null && (mep = axisOp.getMessageExchangePattern()) != null && (mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only"))) {
            try {
                this.calculateResponseTimes(msgContext);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Cannot compute reponse times", (Throwable)axisFault);
            }
        }
    }

    private void calculateResponseTimes(MessageContext msgContext) throws AxisFault {
        Object receivedTime;
        MessageContext inMsgCtx;
        OperationContext opctx = msgContext.getOperationContext();
        if (opctx != null && (inMsgCtx = opctx.getMessageContext("In")) != null && (receivedTime = inMsgCtx.getProperty("wso2statistics.request.received.time")) != null) {
            AxisOperation axisOperation;
            long responseTime = System.currentTimeMillis() - Long.parseLong(receivedTime.toString());
            Parameter globalReqCounterParam = inMsgCtx.getParameter("wso2statistics.GlobalRequestCounter");
            int globalReqCount = 0;
            if (globalReqCounterParam != null) {
                globalReqCount = ((Counter)globalReqCounterParam.getValue()).getCount();
            }
            StatisticsModule.responseTimeProcessor.addResponseTime(responseTime, globalReqCount, msgContext);
            AxisService axisService = msgContext.getAxisService();
            if (axisService != null) {
                Parameter parameter = axisService.getParameter("wso2statistics.ServiceResponseTimeProc");
                Parameter srcParam = axisService.getParameter("wso2statistics.ServiceRequestCounter");
                int srcCount = 0;
                if (srcParam != null) {
                    srcCount = ((Counter)srcParam.getValue()).getCount();
                }
                if (parameter != null) {
                    ((ResponseTimeProcessor)parameter.getValue()).addResponseTime(responseTime, srcCount, msgContext);
                } else {
                    ResponseTimeProcessor proc = new ResponseTimeProcessor();
                    proc.addResponseTime(responseTime, srcCount, msgContext);
                    parameter = new Parameter();
                    parameter.setName("wso2statistics.ServiceResponseTimeProc");
                    parameter.setValue((Object)proc);
                    axisService.addParameter(parameter);
                }
            }
            if ((axisOperation = msgContext.getAxisOperation()) != null) {
                Parameter parameter = axisOperation.getParameter("wso2statistics.OperationResponseTimeProc");
                Parameter opReqCounterParam = axisOperation.getParameter("wso2statistics.InOperationCounter");
                int opReqCount = 0;
                if (opReqCounterParam != null) {
                    opReqCount = ((Counter)opReqCounterParam.getValue()).getCount();
                }
                if (parameter != null) {
                    ((ResponseTimeProcessor)parameter.getValue()).addResponseTime(responseTime, opReqCount, msgContext);
                } else {
                    ResponseTimeProcessor proc = new ResponseTimeProcessor();
                    proc.addResponseTime(responseTime, opReqCount, msgContext);
                    parameter = new Parameter();
                    parameter.setName("wso2statistics.OperationResponseTimeProc");
                    parameter.setValue((Object)proc);
                    axisOperation.addParameter(parameter);
                }
            }
        }
    }
}

