/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.xkms2.builder;

import java.security.Key;

import org.apache.axiom.om.OMElement;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.RecoverRequest;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.XKRRSTestCase;
import org.wso2.xkms2.util.XKMSUtil;

public class RecoverRequestBuilderTest extends XKRRSTestCase {

    private Key authKey = XKMSUtil.getAuthenticationKey("secret");

    public RecoverRequestBuilderTest() {
        super("RecoverRequestBuilderTest");
    }

    public void testBuilder() throws XKMSException, XMLSignatureException {
        OMElement recoverRequestElem = getResourceAsElement("T4_RecoverRequest-http.xml");
        RecoverRequest recoverRequest = (RecoverRequest) RecoverRequestBuilder.INSTANCE
                .buildElement(recoverRequestElem);
        
        Authentication authentication = recoverRequest.getAuthentication();
        XMLSignature keyBindingAuthentication = authentication
                .getKeyBindingAuthentication();
        
        assertTrue(keyBindingAuthentication.checkSignatureValue(authKey));
    }
}
