
//  Example stubs for complexSigsService operations.  This function is not intended 
//  to be called, but rather as a source for copy-and-paste development.

function stubs()
{
    // echoanyType operation
    try {
        /* xs:anyType */ echoanyTypeReturn = complexSigsService.echoanyType(/* xs:anyType */ param_testanyType);
    } catch (e) {
        // fault handling
    }

    // echoanyURI operation
    try {
        /* xs:anyURI */ echoanyURIReturn = complexSigsService.echoanyURI(/* xs:anyURI */ param_testanyURI);
    } catch (e) {
        // fault handling
    }

    // echobase64Binary operation
    try {
        /* xs:base64Binary */ echobase64BinaryReturn = complexSigsService.echobase64Binary(/* xs:base64Binary */ param_testbase64Binary);
    } catch (e) {
        // fault handling
    }

    // echoboolean operation
    try {
        /* xs:boolean */ echobooleanReturn = complexSigsService.echoboolean(/* xs:boolean */ param_testboolean);
    } catch (e) {
        // fault handling
    }

    // echobyte operation
    try {
        /* xs:byte */ echobyteReturn = complexSigsService.echobyte(/* xs:byte */ param_testbyte);
    } catch (e) {
        // fault handling
    }

    // echodate operation
    try {
        /* xs:date */ echodateReturn = complexSigsService.echodate(/* xs:date */ param_testdate);
    } catch (e) {
        // fault handling
    }

    // echodateTime operation
    try {
        /* xs:dateTime */ echodateTimeReturn = complexSigsService.echodateTime(/* xs:dateTime */ param_testdateTime);
    } catch (e) {
        // fault handling
    }

    // echodecimal operation
    try {
        /* xs:decimal */ echodecimalReturn = complexSigsService.echodecimal(/* xs:decimal */ param_testdecimal);
    } catch (e) {
        // fault handling
    }

    // echodouble operation
    try {
        /* xs:double */ echodoubleReturn = complexSigsService.echodouble(/* xs:double */ param_testdouble);
    } catch (e) {
        // fault handling
    }

    // echoduration operation
    try {
        /* xs:duration */ echodurationReturn = complexSigsService.echoduration(/* xs:duration */ param_testduration);
    } catch (e) {
        // fault handling
    }

    // echoENTITIES operation
    try {
        /* xs:ENTITIES */ echoENTITIESReturn = complexSigsService.echoENTITIES(/* xs:ENTITIES */ param_testENTITIES);
    } catch (e) {
        // fault handling
    }

    // echoENTITY operation
    try {
        /* xs:ENTITY */ echoENTITYReturn = complexSigsService.echoENTITY(/* xs:ENTITY */ param_testENTITY);
    } catch (e) {
        // fault handling
    }

    // echofloat operation
    try {
        /* xs:float */ echofloatReturn = complexSigsService.echofloat(/* xs:float */ param_testfloat);
    } catch (e) {
        // fault handling
    }

    // echogDay operation
    try {
        /* xs:gDay */ echogDayReturn = complexSigsService.echogDay(/* xs:gDay */ param_testgDay);
    } catch (e) {
        // fault handling
    }

    // echogMonth operation
    try {
        /* xs:gMonth */ echogMonthReturn = complexSigsService.echogMonth(/* xs:gMonth */ param_testgMonth);
    } catch (e) {
        // fault handling
    }

    // echogMonthDay operation
    try {
        /* xs:gMonthDay */ echogMonthDayReturn = complexSigsService.echogMonthDay(/* xs:gMonthDay */ param_testgMonthDay);
    } catch (e) {
        // fault handling
    }

    // echogYear operation
    try {
        /* xs:gYear */ echogYearReturn = complexSigsService.echogYear(/* xs:gYear */ param_testgYear);
    } catch (e) {
        // fault handling
    }

    // echogYearMonth operation
    try {
        /* xs:gYearMonth */ echogYearMonthReturn = complexSigsService.echogYearMonth(/* xs:gYearMonth */ param_testgYearMonth);
    } catch (e) {
        // fault handling
    }

    // echohexBinary operation
    try {
        /* xs:hexBinary */ echohexBinaryReturn = complexSigsService.echohexBinary(/* xs:hexBinary */ param_testhexBinary);
    } catch (e) {
        // fault handling
    }

    // echoID operation
    try {
        /* xs:ID */ echoIDReturn = complexSigsService.echoID(/* xs:ID */ param_testID);
    } catch (e) {
        // fault handling
    }

    // echoIDREF operation
    try {
        /* xs:IDREF */ echoIDREFReturn = complexSigsService.echoIDREF(/* xs:IDREF */ param_testIDREF);
    } catch (e) {
        // fault handling
    }

    // echoIDREFS operation
    try {
        /* xs:IDREFS */ echoIDREFSReturn = complexSigsService.echoIDREFS(/* xs:IDREFS */ param_testIDREFS);
    } catch (e) {
        // fault handling
    }

    // echoint operation
    try {
        /* xs:int */ echointReturn = complexSigsService.echoint(/* xs:int */ param_testint);
    } catch (e) {
        // fault handling
    }

    // echointeger operation
    try {
        /* xs:integer */ echointegerReturn = complexSigsService.echointeger(/* xs:integer */ param_testinteger);
    } catch (e) {
        // fault handling
    }

    // echolanguage operation
    try {
        /* xs:language */ echolanguageReturn = complexSigsService.echolanguage(/* xs:language */ param_testlanguage);
    } catch (e) {
        // fault handling
    }

    // echolong operation
    try {
        /* xs:long */ echolongReturn = complexSigsService.echolong(/* xs:long */ param_testlong);
    } catch (e) {
        // fault handling
    }

    // echoName operation
    try {
        /* xs:Name */ echoNameReturn = complexSigsService.echoName(/* xs:Name */ param_testName);
    } catch (e) {
        // fault handling
    }

    // echoNCName operation
    try {
        /* xs:NCName */ echoNCNameReturn = complexSigsService.echoNCName(/* xs:NCName */ param_testNCName);
    } catch (e) {
        // fault handling
    }

    // echonegativeInteger operation
    try {
        /* xs:negativeInteger */ echonegativeIntegerReturn = complexSigsService.echonegativeInteger(/* xs:negativeInteger */ param_testnegativeInteger);
    } catch (e) {
        // fault handling
    }

    // echoNMTOKEN operation
    try {
        /* xs:NMTOKEN */ echoNMTOKENReturn = complexSigsService.echoNMTOKEN(/* xs:NMTOKEN */ param_testNMTOKEN);
    } catch (e) {
        // fault handling
    }

    // echoNMTOKENS operation
    try {
        /* xs:NMTOKENS */ echoNMTOKENSReturn = complexSigsService.echoNMTOKENS(/* xs:NMTOKENS */ param_testNMTOKENS);
    } catch (e) {
        // fault handling
    }

    // echononNegativeInteger operation
    try {
        /* xs:nonNegativeInteger */ echononNegativeIntegerReturn = complexSigsService.echononNegativeInteger(/* xs:nonNegativeInteger */ param_testnonNegativeInteger);
    } catch (e) {
        // fault handling
    }

    // echononPositiveInteger operation
    try {
        /* xs:nonPositiveInteger */ echononPositiveIntegerReturn = complexSigsService.echononPositiveInteger(/* xs:nonPositiveInteger */ param_testnonPositiveInteger);
    } catch (e) {
        // fault handling
    }

    // echonormalizedString operation
    try {
        /* xs:normalizedString */ echonormalizedStringReturn = complexSigsService.echonormalizedString(/* xs:normalizedString */ param_testnormalizedString);
    } catch (e) {
        // fault handling
    }

    // echoNOTATION operation
    try {
        /* xs:NOTATION */ echoNOTATIONReturn = complexSigsService.echoNOTATION(/* xs:NOTATION */ param_testNOTATION);
    } catch (e) {
        // fault handling
    }

    // echopositiveInteger operation
    try {
        /* xs:positiveInteger */ echopositiveIntegerReturn = complexSigsService.echopositiveInteger(/* xs:positiveInteger */ param_testpositiveInteger);
    } catch (e) {
        // fault handling
    }

    // echoQName operation
    try {
        /* xs:QName */ echoQNameReturn = complexSigsService.echoQName(/* xs:QName */ param_testQName);
    } catch (e) {
        // fault handling
    }

    // echoshort operation
    try {
        /* xs:short */ echoshortReturn = complexSigsService.echoshort(/* xs:short */ param_testshort);
    } catch (e) {
        // fault handling
    }

    // echostring operation
    try {
        /* xs:string */ echostringReturn = complexSigsService.echostring(/* xs:string */ param_teststring);
    } catch (e) {
        // fault handling
    }

    // echotime operation
    try {
        /* xs:time */ echotimeReturn = complexSigsService.echotime(/* xs:time */ param_testtime);
    } catch (e) {
        // fault handling
    }

    // echotoken operation
    try {
        /* xs:token */ echotokenReturn = complexSigsService.echotoken(/* xs:token */ param_testtoken);
    } catch (e) {
        // fault handling
    }

    // echounsignedByte operation
    try {
        /* xs:unsignedByte */ echounsignedByteReturn = complexSigsService.echounsignedByte(/* xs:unsignedByte */ param_testunsignedByte);
    } catch (e) {
        // fault handling
    }

    // echounsignedInt operation
    try {
        /* xs:unsignedInt */ echounsignedIntReturn = complexSigsService.echounsignedInt(/* xs:unsignedInt */ param_testunsignedInt);
    } catch (e) {
        // fault handling
    }

    // echounsignedLong operation
    try {
        /* xs:unsignedLong */ echounsignedLongReturn = complexSigsService.echounsignedLong(/* xs:unsignedLong */ param_testunsignedLong);
    } catch (e) {
        // fault handling
    }

    // echounsignedShort operation
    try {
        /* xs:unsignedShort */ echounsignedShortReturn = complexSigsService.echounsignedShort(/* xs:unsignedShort */ param_testunsignedShort);
    } catch (e) {
        // fault handling
    }

}

var complexSigsService = new WebService("http://192.168.1.53:9762/soap/complexSigs");

complexSigsService.echoanyType =
    function echoanyType(/* xs:anyType */ _testanyType)
    {
        var request = 
            <echoanyType xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testanyType xmlns="">{_testanyType}</testanyType>
            </echoanyType> ;
        var response = complexSigsService._call(request);
        return /* xs:anyType */ response;
    }

complexSigsService.echoanyURI =
    function echoanyURI(/* xs:anyURI */ _testanyURI)
    {
        var request = 
            <echoanyURI xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testanyURI xmlns="">{_testanyURI}</testanyURI>
            </echoanyURI> ;
        var response = complexSigsService._call(request);
        return /* xs:anyURI */ response["returnanyURI"].toString();
    }

complexSigsService.echobase64Binary =
    function echobase64Binary(/* xs:base64Binary */ _testbase64Binary)
    {
        var request = 
            <echobase64Binary xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testbase64Binary xmlns="">{_testbase64Binary}</testbase64Binary>
            </echobase64Binary> ;
        var response = complexSigsService._call(request);
        return /* xs:base64Binary */ response["returnbase64Binary"].toString();
    }

complexSigsService.echoboolean =
    function echoboolean(/* xs:boolean */ _testboolean)
    {
        var request = 
            <echoboolean xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testboolean xmlns="">{_testboolean}</testboolean>
            </echoboolean> ;
        var response = complexSigsService._call(request);
        return /* Boolean */ response["returnboolean"] == "true" or returnboolean"] == "1";
    }

complexSigsService.echobyte =
    function echobyte(/* xs:byte */ _testbyte)
    {
        var request = 
            <echobyte xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testbyte xmlns="">{_testbyte}</testbyte>
            </echobyte> ;
        var response = complexSigsService._call(request);
        return /* xs:byte */ parseInt(response["returnbyte"]);
    }

complexSigsService.echodate =
    function echodate(/* xs:date */ _testdate)
    {
        var request = 
            <echodate xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testdate xmlns="">{_testdate}</testdate>
            </echodate> ;
        var response = complexSigsService._call(request);
        return /* Date */ xs_dateTime_to_date(response["returndate"]);
    }

complexSigsService.echodateTime =
    function echodateTime(/* xs:dateTime */ _testdateTime)
    {
        var request = 
            <echodateTime xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testdateTime xmlns="">{_testdateTime}</testdateTime>
            </echodateTime> ;
        var response = complexSigsService._call(request);
        return /* Date */ xs_dateTime_to_date(response["returndateTime"]);
    }

complexSigsService.echodecimal =
    function echodecimal(/* xs:decimal */ _testdecimal)
    {
        var request = 
            <echodecimal xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testdecimal xmlns="">{_testdecimal}</testdecimal>
            </echodecimal> ;
        var response = complexSigsService._call(request);
        return /* xs:decimal */ response["returndecimal"].toString();
    }

complexSigsService.echodouble =
    function echodouble(/* xs:double */ _testdouble)
    {
        var request = 
            <echodouble xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testdouble xmlns="">{_testdouble}</testdouble>
            </echodouble> ;
        var response = complexSigsService._call(request);
        return /* xs:double */ parseFloat(response["returndouble"]);
    }

complexSigsService.echoduration =
    function echoduration(/* xs:duration */ _testduration)
    {
        var request = 
            <echoduration xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testduration xmlns="">{_testduration}</testduration>
            </echoduration> ;
        var response = complexSigsService._call(request);
        return /* xs:duration */ parseInt(response["returnduration"]);
    }

complexSigsService.echoENTITIES =
    function echoENTITIES(/* xs:ENTITIES */ _testENTITIES)
    {
        var request = 
            <echoENTITIES xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testENTITIES xmlns="">{_testENTITIES}</testENTITIES>
            </echoENTITIES> ;
        var response = complexSigsService._call(request);
        return /* array of xs:ENTITY */ response["returnENTITIES"].split(' '));
    }

complexSigsService.echoENTITY =
    function echoENTITY(/* xs:ENTITY */ _testENTITY)
    {
        var request = 
            <echoENTITY xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testENTITY xmlns="">{_testENTITY}</testENTITY>
            </echoENTITY> ;
        var response = complexSigsService._call(request);
        return /* xs:ENTITY */ response["returnENTITY"].toString();
    }

complexSigsService.echofloat =
    function echofloat(/* xs:float */ _testfloat)
    {
        var request = 
            <echofloat xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testfloat xmlns="">{_testfloat}</testfloat>
            </echofloat> ;
        var response = complexSigsService._call(request);
        return /* xs:float */ parseFloat(response["returnfloat"]);
    }

complexSigsService.echogDay =
    function echogDay(/* xs:gDay */ _testgDay)
    {
        var request = 
            <echogDay xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testgDay xmlns="">{_testgDay}</testgDay>
            </echogDay> ;
        var response = complexSigsService._call(request);
        return /* xs:gDay */ parseInt(response["returngDay"]);
    }

complexSigsService.echogMonth =
    function echogMonth(/* xs:gMonth */ _testgMonth)
    {
        var request = 
            <echogMonth xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testgMonth xmlns="">{_testgMonth}</testgMonth>
            </echogMonth> ;
        var response = complexSigsService._call(request);
        return /* xs:gMonth */ parseInt(response["returngMonth"]);
    }

complexSigsService.echogMonthDay =
    function echogMonthDay(/* xs:gMonthDay */ _testgMonthDay)
    {
        var request = 
            <echogMonthDay xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testgMonthDay xmlns="">{_testgMonthDay}</testgMonthDay>
            </echogMonthDay> ;
        var response = complexSigsService._call(request);
        var d = response["returngMonthDay"];
        return /* Date */ response["returngMonthDay"].split(' '));
    }

complexSigsService.echogYear =
    function echogYear(/* xs:gYear */ _testgYear)
    {
        var request = 
            <echogYear xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testgYear xmlns="">{_testgYear}</testgYear>
            </echogYear> ;
        var response = complexSigsService._call(request);
        return /* xs:gYear */ parseInt(response["returngYear"]);
    }

complexSigsService.echogYearMonth =
    function echogYearMonth(/* xs:gYearMonth */ _testgYearMonth)
    {
        var request = 
            <echogYearMonth xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testgYearMonth xmlns="">{_testgYearMonth}</testgYearMonth>
            </echogYearMonth> ;
        var response = complexSigsService._call(request);
        var d = response["returngYearMonth"];
        return /* Date */ response["returngYearMonth"].split(' '));
    }

complexSigsService.echohexBinary =
    function echohexBinary(/* xs:hexBinary */ _testhexBinary)
    {
        var request = 
            <echohexBinary xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testhexBinary xmlns="">{_testhexBinary}</testhexBinary>
            </echohexBinary> ;
        var response = complexSigsService._call(request);
        return /* xs:hexBinary */ response["returnhexBinary"].toString();
    }

complexSigsService.echoID =
    function echoID(/* xs:ID */ _testID)
    {
        var request = 
            <echoID xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testID xmlns="">{_testID}</testID>
            </echoID> ;
        var response = complexSigsService._call(request);
        return /* xs:ID */ response["returnID"].toString();
    }

complexSigsService.echoIDREF =
    function echoIDREF(/* xs:IDREF */ _testIDREF)
    {
        var request = 
            <echoIDREF xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testIDREF xmlns="">{_testIDREF}</testIDREF>
            </echoIDREF> ;
        var response = complexSigsService._call(request);
        return /* xs:IDREF */ response["returnIDREF"].toString();
    }

complexSigsService.echoIDREFS =
    function echoIDREFS(/* xs:IDREFS */ _testIDREFS)
    {
        var request = 
            <echoIDREFS xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testIDREFS xmlns="">{_testIDREFS}</testIDREFS>
            </echoIDREFS> ;
        var response = complexSigsService._call(request);
        return /* array of xs:IDREF */ response["returnIDREFS"].split(' '));
    }

complexSigsService.echoint =
    function echoint(/* xs:int */ _testint)
    {
        var request = 
            <echoint xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testint xmlns="">{_testint}</testint>
            </echoint> ;
        var response = complexSigsService._call(request);
        return /* xs:int */ parseInt(response["returnint"]);
    }

complexSigsService.echointeger =
    function echointeger(/* xs:integer */ _testinteger)
    {
        var request = 
            <echointeger xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testinteger xmlns="">{_testinteger}</testinteger>
            </echointeger> ;
        var response = complexSigsService._call(request);
        return /* xs:integer */ parseInt(response["returninteger"]);
    }

complexSigsService.echolanguage =
    function echolanguage(/* xs:language */ _testlanguage)
    {
        var request = 
            <echolanguage xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testlanguage xmlns="">{_testlanguage}</testlanguage>
            </echolanguage> ;
        var response = complexSigsService._call(request);
        return /* xs:language */ response["returnlanguage"].toString();
    }

complexSigsService.echolong =
    function echolong(/* xs:long */ _testlong)
    {
        var request = 
            <echolong xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testlong xmlns="">{_testlong}</testlong>
            </echolong> ;
        var response = complexSigsService._call(request);
        return /* xs:long */ parseInt(response["returnlong"]);
    }

complexSigsService.echoName =
    function echoName(/* xs:Name */ _testName)
    {
        var request = 
            <echoName xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testName xmlns="">{_testName}</testName>
            </echoName> ;
        var response = complexSigsService._call(request);
        return /* xs:Name */ response["returnName"].toString();
    }

complexSigsService.echoNCName =
    function echoNCName(/* xs:NCName */ _testNCName)
    {
        var request = 
            <echoNCName xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testNCName xmlns="">{_testNCName}</testNCName>
            </echoNCName> ;
        var response = complexSigsService._call(request);
        return /* xs:NCName */ response["returnNCName"].toString();
    }

complexSigsService.echonegativeInteger =
    function echonegativeInteger(/* xs:negativeInteger */ _testnegativeInteger)
    {
        var request = 
            <echonegativeInteger xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testnegativeInteger xmlns="">{_testnegativeInteger}</testnegativeInteger>
            </echonegativeInteger> ;
        var response = complexSigsService._call(request);
        return /* xs:negativeInteger */ parseInt(response["returnnegativeInteger"]);
    }

complexSigsService.echoNMTOKEN =
    function echoNMTOKEN(/* xs:NMTOKEN */ _testNMTOKEN)
    {
        var request = 
            <echoNMTOKEN xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testNMTOKEN xmlns="">{_testNMTOKEN}</testNMTOKEN>
            </echoNMTOKEN> ;
        var response = complexSigsService._call(request);
        return /* xs:NMTOKEN */ response["returnNMTOKEN"].toString();
    }

complexSigsService.echoNMTOKENS =
    function echoNMTOKENS(/* xs:NMTOKENS */ _testNMTOKENS)
    {
        var request = 
            <echoNMTOKENS xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testNMTOKENS xmlns="">{_testNMTOKENS}</testNMTOKENS>
            </echoNMTOKENS> ;
        var response = complexSigsService._call(request);
        return /* array of xs:NMTOKEN */ response["returnNMTOKENS"].split(' '));
    }

complexSigsService.echononNegativeInteger =
    function echononNegativeInteger(/* xs:nonNegativeInteger */ _testnonNegativeInteger)
    {
        var request = 
            <echononNegativeInteger xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testnonNegativeInteger xmlns="">{_testnonNegativeInteger}</testnonNegativeInteger>
            </echononNegativeInteger> ;
        var response = complexSigsService._call(request);
        return /* xs:nonNegativeInteger */ parseInt(response["returnnonNegativeInteger"]);
    }

complexSigsService.echononPositiveInteger =
    function echononPositiveInteger(/* xs:nonPositiveInteger */ _testnonPositiveInteger)
    {
        var request = 
            <echononPositiveInteger xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testnonPositiveInteger xmlns="">{_testnonPositiveInteger}</testnonPositiveInteger>
            </echononPositiveInteger> ;
        var response = complexSigsService._call(request);
        return /* xs:nonPositiveInteger */ parseInt(response["returnnonPositiveInteger"]);
    }

complexSigsService.echonormalizedString =
    function echonormalizedString(/* xs:normalizedString */ _testnormalizedString)
    {
        var request = 
            <echonormalizedString xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testnormalizedString xmlns="">{_testnormalizedString}</testnormalizedString>
            </echonormalizedString> ;
        var response = complexSigsService._call(request);
        return /* xs:normalizedString */ response["returnnormalizedString"].toString();
    }

complexSigsService.echoNOTATION =
    function echoNOTATION(/* xs:NOTATION */ _testNOTATION)
    {
        var request = 
            <echoNOTATION xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testNOTATION xmlns="">{_testNOTATION}</testNOTATION>
            </echoNOTATION> ;
        var response = complexSigsService._call(request);
        return /* xs:NOTATION */ response["returnNOTATION"].toString();
    }

complexSigsService.echopositiveInteger =
    function echopositiveInteger(/* xs:positiveInteger */ _testpositiveInteger)
    {
        var request = 
            <echopositiveInteger xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testpositiveInteger xmlns="">{_testpositiveInteger}</testpositiveInteger>
            </echopositiveInteger> ;
        var response = complexSigsService._call(request);
        return /* xs:positiveInteger */ parseInt(response["returnpositiveInteger"]);
    }

complexSigsService.echoQName =
    function echoQName(/* xs:QName */ _testQName)
    {
        var request = 
            <echoQName xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testQName xmlns="">{_testQName}</testQName>
            </echoQName> ;
        var response = complexSigsService._call(request);
        var qname = response["returnQName"];
        return /* QName */ new QName(qname, qname.namespace(qname.substr(0, qname.indexOf(':'))));
    }

complexSigsService.echoshort =
    function echoshort(/* xs:short */ _testshort)
    {
        var request = 
            <echoshort xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testshort xmlns="">{_testshort}</testshort>
            </echoshort> ;
        var response = complexSigsService._call(request);
        return /* xs:short */ parseInt(response["returnshort"]);
    }

complexSigsService.echostring =
    function echostring(/* xs:string */ _teststring)
    {
        var request = 
            <echostring xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <teststring xmlns="">{_teststring}</teststring>
            </echostring> ;
        var response = complexSigsService._call(request);
        return /* xs:string */ response["returnstring"].toString();
    }

complexSigsService.echotime =
    function echotime(/* xs:time */ _testtime)
    {
        var request = 
            <echotime xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testtime xmlns="">{_testtime}</testtime>
            </echotime> ;
        var response = complexSigsService._call(request);
        return /* Date */ xs_dateTime_to_date(response["returntime"]);
    }

complexSigsService.echotoken =
    function echotoken(/* xs:token */ _testtoken)
    {
        var request = 
            <echotoken xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testtoken xmlns="">{_testtoken}</testtoken>
            </echotoken> ;
        var response = complexSigsService._call(request);
        return /* xs:token */ response["returntoken"].toString();
    }

complexSigsService.echounsignedByte =
    function echounsignedByte(/* xs:unsignedByte */ _testunsignedByte)
    {
        var request = 
            <echounsignedByte xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testunsignedByte xmlns="">{_testunsignedByte}</testunsignedByte>
            </echounsignedByte> ;
        var response = complexSigsService._call(request);
        return /* xs:unsignedByte */ parseInt(response["returnunsignedByte"]);
    }

complexSigsService.echounsignedInt =
    function echounsignedInt(/* xs:unsignedInt */ _testunsignedInt)
    {
        var request = 
            <echounsignedInt xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testunsignedInt xmlns="">{_testunsignedInt}</testunsignedInt>
            </echounsignedInt> ;
        var response = complexSigsService._call(request);
        return /* xs:unsignedInt */ parseInt(response["returnunsignedInt"]);
    }

complexSigsService.echounsignedLong =
    function echounsignedLong(/* xs:unsignedLong */ _testunsignedLong)
    {
        var request = 
            <echounsignedLong xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testunsignedLong xmlns="">{_testunsignedLong}</testunsignedLong>
            </echounsignedLong> ;
        var response = complexSigsService._call(request);
        return /* xs:unsignedLong */ parseInt(response["returnunsignedLong"]);
    }

complexSigsService.echounsignedShort =
    function echounsignedShort(/* xs:unsignedShort */ _testunsignedShort)
    {
        var request = 
            <echounsignedShort xmlns="http://complexSigs.services.wsas.wso2.org/xsd">
                <testunsignedShort xmlns="">{_testunsignedShort}</testunsignedShort>
            </echounsignedShort> ;
        var response = complexSigsService._call(request);
        return /* xs:unsignedShort */ parseInt(response["returnunsignedShort"]);
    }



// WebService object.
function WebService(endpoint)
{
    this._endpoint = endpoint;
    
    // private helper functions
    this._WSRequest = new SOAPHttpRequest();
    this._call =
    function callWS(reqContent)
    {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        
        var option = new Array();
        option = {useSOAP:true};
        this._WSRequest.open(option, this._endpoint, false);
        this._WSRequest.send(reqContent.toXMLString());
       
        //responseXML contains response dom 
        try {
            var resultContent = this._WSRequest.responseText;
            // convert to E4X native XML object
            if (resultContent != "") {
                return new XML(resultContent);
            } else {
                throw("no response");
            }
        } catch (e) {
            throw(e);
        }
    }				
}

// library function for parsing xs:date, xs:time, and xs:dateTime types into Date objects.
function xs_dateTime_to_date(dateTime)
{
    var buffer = dateTime;
    var p = 0; // pointer to current parse location in buffer.
    
    // parse date, if there is one.
    if (buffer.substr(p,1) == '-')
    {
        var era = -1;
        p++;
    } else {
        var era = 1;
    }
    
    if (buffer.charAt(p+2) != ':')
    {
        var year = era * buffer.substr(p,4);
        p += 5;
        var month = buffer.substr(p,2);
        p += 3;
        var day = buffer.substr(p,2);
        p += 3;
    } else {
        var year = 1970;
        var month = 1;
        var day = 1;
    }
    
    // parse time, if there is one
    if (buffer.charAt(p) != '+' && buffer.charAt(p) != '-')
    {
        var hour = buffer.substr(p,2);
        p += 3;
        var minute = buffer.substr(p,2);
        p += 3;
        var second = buffer.substr(p,2);
        p += 2;
        if (buffer.charAt(p) == '.')
        {
            var millisecond = parseFloat(buffer.substr(p))*1000;
            // Note that JS fractional seconds are significant to 3 places - xs:time is significant to more - 
            // though implementations are only required to carry 3 places.
            p++;
            while (buffer.charCodeAt(p) >= 48 && buffer.charCodeAt(p) <= 57) p++;
        } else {
            var millisecond = 0;
        }
    } else {
        var hour = 0;
        var minute = 0;
        var second = 0;
        var millisecond = 0;
    }
    
    // parse time zone
    if (buffer.charAt(p) != 'Z' && buffer.charAt(p) != '') {
        var sign = (buffer.charAt(p) == '-' ? -1 : +1);
        p++;
        var tzhour = sign * buffer.substr(p,2);
        p += 3;
        var tzminute = sign * buffer.substr(p,2);
    }
    
    var thisDate = new Date();
    thisDate.setUTCFullYear(year);
    thisDate.setUTCMonth(month-1);
    thisDate.setUTCDate(day);
    thisDate.setUTCHours(hour);
    thisDate.setUTCMinutes(minute);
    thisDate.setUTCSeconds(second);
    thisDate.setUTCMilliseconds(millisecond);    
    thisDate.setUTCHours(thisDate.getUTCHours() - tzhour);
    thisDate.setUTCMinutes(thisDate.getUTCMinutes() - tzminute);
    return thisDate;
}
