package org.apache.sandesha2.storage;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.util.SandeshaUtil;

/*
 * Copyright 2007 The Apache Software Foundation.
 * Copyright 2007 International Business Machines Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//This tests weather sandesha2 correctly checks Key Conflicts (i.e. when inserting) in it's storage managers.
public class KeyConflictTest extends SandeshaTestCase {

	public KeyConflictTest(String name) {
		super(name);
	}

	public void testKeyConflicts ()  throws AxisFault {
		
		try {
			AxisConfiguration axisConfiguration = new AxisConfiguration ();
			ConfigurationContext configurationContext = new ConfigurationContext (axisConfiguration);
			
			//setting a dummy property been to stop Sandesha2 from throwing exceptions.
			SandeshaPolicyBean policyBean = new SandeshaPolicyBean ();
			axisConfiguration.addParameter(new Parameter (Sandesha2Constants.SANDESHA_PROPERTY_BEAN,policyBean));
			
			InMemoryStorageManager storageManager = new InMemoryStorageManager (configurationContext);
			
			Transaction transaction = storageManager.getTransaction();
			
			RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
			
			RMSBean rmsBean = new RMSBean ();
			RMSBean duplicateRMSBean = new RMSBean ();
			
			rmsBean.setCreateSeqMsgID(SandeshaUtil.getUUID());
			duplicateRMSBean.setCreateSeqMsgID(SandeshaUtil.getUUID());
			
			String sequenceId = SandeshaUtil.getUUID();
			
			//we duplicate this sequenceID in both RMSBeans.
			rmsBean.setSequenceID(sequenceId);
			duplicateRMSBean.setSequenceID(sequenceId);
			
			rmsBeanMgr.insert(rmsBean);
			
			boolean exceptionThrown = false;
			try {
				rmsBeanMgr.insert(duplicateRMSBean);
			} catch (SandeshaStorageException e) {
				exceptionThrown = true;
			}
			
			transaction.commit();
			
			assertTrue(exceptionThrown);
		} catch (SandeshaStorageException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SandeshaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
}
