/*
 * Copyright  1999-2004 The Apache Software Foundation.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.sandesha2.storage.beans;

import java.io.Serializable;

import org.apache.sandesha2.storage.Transaction;

/**
 * Defines a data bean used and managed by Sandesha2.
 */

public abstract class RMBean implements Serializable {
		
		private long id;
		private transient Transaction transaction;
		
		public long getId() {
			return id;
		}
		
		protected void setId(long id) {
			this.id = id;
		}
		public Transaction getTransaction() {
			return transaction;
		}

		public void setTransaction(Transaction transaction) {
			this.transaction = transaction;
		}
		
		/**
		 * Check to see if this bean matches the match criteria passed in
		 * as matchInfo. In order for a property of the bean to be checked
		 * you must set the property on the matchInfo.
		 */
		public abstract boolean match(RMBean matchInfo);
}
