/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.axis2.rmi.metadata.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.apache.axis2.rmi.exception.SchemaGenerationException;

import java.util.Map;

/**
 * this class represents and xml attribute
 */
public interface XmlAttribute {

    public void generateWSDLSchema(Document document, Map namespacesToPrefixMap) throws SchemaGenerationException;

    public String getNamespace();

    public void setNamespace(String namespace);

    public boolean isRequired();

    public void setRequired(boolean required);

    public XmlType getType();

    public void setType(XmlType type);

    public String getName();

    public void setName(String name);

    public Element getAttribute();

    public void setAttribute(Element attribute);

}
