/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axis2.dataretrieval;

/**
 * Data contains instance of the data Object for the specified identifier if applicable.
 */

public class Data {
    Object data;
    String identifier;


    /**
     * Constructor
     *
     * @param in_data       instance of Object about the data
     * @param in_identifier identifier of the data instance.
     */
    public Data(Object in_data, String in_identifier) {
        super();
        data = in_data;
        identifier = in_identifier;
    }

    /**
     * Returns data
     *
     * @return data Object
     */

    public Object getData() {
        return data;
    }

    /**
     * Returns string representing identifier of this data object.
     *
     * @return
     */
    public String getIdentifier() {
        return identifier;
    }
}
