<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="ns1:enableTimestampResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="isEnabled"><xsl:value-of select="return/enabled" /></xsl:variable>
                <xsl:variable name="istimestampFirst"><xsl:value-of select="return/timestampFirst" /></xsl:variable>
                <div>
                    <div>
                        <span>
                            <input id="inflow_checkbox" tabindex="1">
                                <xsl:attribute name="type">checkbox</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:timestampFlowConfig(this,1);</xsl:attribute>
                                <xsl:if test="$isEnabled='true'">
                                    <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>
                            </input>
                            Timestamp
                            <br/>
                        </span>
                    </div>
                    <xsl:if test="$isEnabled='true'">
                        <div id='inflow_timestamp'>
                            <input type="radio" name="inflowGroup" tabindex="2">
                                <xsl:attribute name="value">true</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_INFLOW_CONFIG_ADMIN_STRING,this.value,1,showTSInflowConfigurationCallback);return true;</xsl:attribute>
                                <xsl:if test="$istimestampFirst='true'">
                                     <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>

                            </input>
                            First
                            <br/>
                            <input type="radio" name="inflowGroup" tabindex="3">
                                <xsl:attribute name="value">false</xsl:attribute>
                                <xsl:if test="$istimestampFirst='false'">
                                     <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>
                                <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_INFLOW_CONFIG_ADMIN_STRING,this.value,1,showTSInflowConfigurationCallback);return true;</xsl:attribute>
                            </input>
                            Last
                            <br/>
                        </div>
                    </xsl:if>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div>Problem encountered displaying Inflow Timestamp Configuration</div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ns1:disableTimestampResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="isEnabled"><xsl:value-of select="return/enabled" /></xsl:variable>
                <xsl:variable name="istimestampFirst"><xsl:value-of select="return/timestampFirst" /></xsl:variable>
                <div>
                    <div>
                        <span>
                            <input id="inflow_checkbox" tabindex="1">
                                <xsl:attribute name="type">checkbox</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:timestampFlowConfig(this,1);</xsl:attribute>
                                <xsl:if test="$isEnabled='true'">
                                    <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>
                            </input>
                            Timestamp
                            <br/>
                        </span>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div>Problem encountered displaying Inflow Timestamp Configuration</div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ns1:setTimestampOrderResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="isEnabled"><xsl:value-of select="return/enabled" /></xsl:variable>
                <xsl:variable name="istimestampFirst"><xsl:value-of select="return/timestampFirst" /></xsl:variable>
                <div>
                    <div>
                        <span>
                            <input id="inflow_checkbox" tabindex="1">
                                <xsl:attribute name="type">checkbox</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:timestampFlowConfig(this,1);</xsl:attribute>
                                <xsl:if test="$isEnabled='true'">
                                    <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>
                            </input>
                            Timestamp
                            <br/>
                        </span>
                    </div>
                    <xsl:if test="$isEnabled='true'">
                        <div id='inflow_timestamp'>
                            <input type="radio" name="inflowGroup" tabindex="2">
                                <xsl:attribute name="value">true</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_INFLOW_CONFIG_ADMIN_STRING,this.value,1,showTSInflowConfigurationCallback);return true;</xsl:attribute>
                                <xsl:if test="$istimestampFirst='true'">
                                     <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>

                            </input>
                            First
                            <br/>
                            <input type="radio" name="inflowGroup" tabindex="3">
                                <xsl:attribute name="value">false</xsl:attribute>
                                <xsl:if test="$istimestampFirst='false'">
                                     <xsl:attribute name="checked">true</xsl:attribute>
                                </xsl:if>
                                <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_INFLOW_CONFIG_ADMIN_STRING,this.value,1,showTSInflowConfigurationCallback);return true;</xsl:attribute>
                            </input>
                            Last
                            <br/>
                        </div>
                    </xsl:if>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div>Problem encountered displaying Inflow Timestamp Configuration</div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
