<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />

    <xsl:template match="ns1:getStatusResponse" xmlns:ns1="http://org.apache.axis2/xsd">

        <h2>@server_name@ Home</h2>
        <p>
            Welcome to the @server_name@ Management Console.
        </p>
        <p>&#160;</p>
        <div id="formset">
            <table class="styledLeft">
            <thead><tr><th colspan="2">System Summary</th></tr></thead>
            <xsl:for-each select="return">
                <tr>
                <td><strong>Server Name</strong></td>
                <td><xsl:value-of select="serverName"/></td>
                </tr>
                <tr>
                <td><strong>Server Version</strong></td>
                <td><xsl:value-of select="wso2wsasVersion"/></td>
                </tr>
                <tr>
                <td><strong>Server Start Time</strong></td>
                <td><xsl:value-of select="serverStartTime"/></td>
                </tr>
                <tr>
                <td><strong>System Up Time</strong></td>
                <td><xsl:value-of select="systemUpTime"/></td>
                </tr>
                <tr>
                <td><strong>Memory Allocated</strong></td>
                <td><xsl:value-of select="totalMemory/value"/><xsl:value-of select="totalMemory/unit"/></td>
                </tr>
                <tr>
                <td><strong>Memory Usage</strong></td>
                <td><xsl:value-of select="usedMemory/value"/><xsl:value-of select="usedMemory/unit"/></td>
                </tr>
                <thead><tr><th colspan="2">Service Summary</th></tr></thead>
                <tr>
                <td><strong>Total Request Count</strong></td>
                <td><xsl:value-of select="requestCount"/></td>
                </tr>
                <tr>
                <td><strong>Total Response Count</strong></td>
                <td><xsl:value-of select="responseCount"/></td>
                </tr>
                <tr>
                <td><strong>Total Fault Count</strong></td>
                <td><xsl:value-of select="faultCount"/></td>
                </tr>
                <tr>
                <td><strong>Active Services</strong></td>
                <td><xsl:value-of select="services"/></td>
                </tr>
            </xsl:for-each>
            </table>

            <table border="0">
                <!--<tr>
                <td>
                <a target="_blank" href="about.html">
                <img src="extensions/core/images/about.gif" align="left" border="0"/>
                </a>
                </td>
                <td><strong><a target="_blank" href="about.html">About</a></strong><br/>
                    WSO2 Web Services Application Server.
                </td>
                </tr>-->

                <tr>
                <td>
                <a target="_blank" href="docs/user_guide.html">
                <img src="extensions/core/images/user_guide-.gif" align="left" border="0"/>
                </a>
                </td>
                <td><strong><a target="_blank" href="docs/user_guide.html">User Guide</a></strong><br/>
                    WSO2 Web Services Application Server user guide.
                </td>
                </tr>

                <tr>
                <td>
                <a target="_blank" href="http://wso2.org/forum">
                <img src="extensions/core/images/forum.gif" align="left" border="0"/>
                </a>
                </td>
                <td><strong><a target="_blank" href="http://wso2.org/forum" class="exlink">Forum</a></strong><br/>
                    The interactive message board for sharing information, questions and comments about WSO2 products.
                </td>
                </tr>

                <tr>
                <td>
                <a target="_blank" href="https://wso2.org/jira/browse/WSAS">
                <img src="extensions/core/images/jira.gif" align="left" border="0"/>
                </a>
                </td>
                <td><strong><a target="_blank" href="https://wso2.org/jira/browse/WSAS" class="exlink">Issue Tracker</a></strong><br/>
                    Users are encouraged use the issue tracker to report issues &amp; suggest improvements using the JIRA issue tracker.
                    In addition users will be able to observe the status of the items in progress.
                </td>
                </tr>

                <tr>
                <td><a target="_blank" href="http://wso2.org/mail">
                <img src="extensions/core/images/mailing_lists.gif" align="left" border="0"/>
                </a>
                </td>
                <td><strong><a target="_blank" href="http://wso2.org/mail" class="exlink">Mailing Lists</a></strong><br/>
                    Report issues, provide feedback &amp; get help from our mailing lists.
                </td>
                </tr>
            </table>
        </div>
    </xsl:template>
</xsl:stylesheet>
